/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.construction.MeshVisitor;
import net.nowina.cadmelia.construction.Shape;
import net.nowina.cadmelia.construction.ShapeFactory;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ModuleExec;
import net.nowina.cadmelia.script.ScriptContext;

public class TextModule
extends ModuleExec {
    private FactoryBuilder factory;

    public TextModule(FactoryBuilder factory) {
        super("text");
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        ShapeFactory builder = this.factory.createShapeFactory();
        String text = null;
        Expression textExpr = op.getFirstUnamedArg();
        if (textExpr != null) {
            text = textExpr.evaluateAsString(context);
        } else {
            textExpr = op.getArg("text");
            if (textExpr != null) {
                text = textExpr.evaluateAsString(context);
            }
        }
        int size = 10;
        Expression sizeExpr = op.getArg("size");
        if (sizeExpr != null) {
            size = sizeExpr.evaluateAsInteger(context);
        }
        String valign = "bottom";
        Expression valignExpr = op.getArg("valign");
        if (valignExpr != null) {
            valign = valignExpr.evaluateAsString(context);
        }
        String halign = "left";
        Expression halignExpr = op.getArg("halign");
        if (halignExpr != null) {
            halign = halignExpr.evaluateAsString(context);
        }
        Shape textShape = builder.text(text, size, "Arial");
        switch (valign) {
            case "bottom": {
                break;
            }
            case "top": {
                textShape = textShape.translate(0.0, -this.shapeHeight((Construction)textShape), 0.0);
                break;
            }
            case "center": {
                textShape = textShape.translate(0.0, -this.shapeHeight((Construction)textShape) / 2.0, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value '" + valign + "' for param valign");
            }
        }
        switch (halign) {
            case "left": {
                break;
            }
            case "right": {
                textShape = textShape.translate(-this.shapeWidth((Construction)textShape), 0.0, 0.0);
                break;
            }
            case "center": {
                textShape = textShape.translate(-this.shapeWidth((Construction)textShape) / 2.0, 0.0, 0.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value '" + halign + "' for param halign");
            }
        }
        return textShape;
    }

    public double shapeHeight(Construction textShape) {
        BoundMeshVisitor visitor = new BoundMeshVisitor();
        textShape.visit((MeshVisitor)visitor);
        return visitor.height;
    }

    public double shapeWidth(Construction textShape) {
        BoundMeshVisitor visitor = new BoundMeshVisitor();
        textShape.visit((MeshVisitor)visitor);
        return visitor.width;
    }

    static class BoundMeshVisitor
    implements MeshVisitor {
        double height = 0.0;
        double width = 0.0;

        BoundMeshVisitor() {
        }

        public void triangle(Vector p1, Vector p2, Vector p3) {
            this.width = Math.max(this.width, Math.max(p1.x(), Math.max(p2.x(), p3.x())));
            this.height = Math.max(this.height, Math.max(p1.y(), Math.max(p2.y(), p3.y())));
        }
    }
}

