/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ModuleExec;
import net.nowina.cadmelia.script.ScriptContext;

public class SquareModule
extends ModuleExec {
    public static final String MODULE_NAME = "square";
    private FactoryBuilder factory;

    public SquareModule(FactoryBuilder factory) {
        super(MODULE_NAME);
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Vector sizeV = new Vector(1.0, 1.0, 0.0);
        Expression sizeExpr = op.getArg("size");
        if (sizeExpr == null && op.getArgCount() > 1) {
            sizeExpr = op.getArg(0);
        }
        if (sizeExpr != null) {
            Literal obj = sizeExpr.evaluate(context);
            if (obj.isVector()) {
                sizeV = obj.asVector();
            } else {
                double size = obj.asDouble();
                sizeV = new Vector(size, size, 0.0);
            }
        }
        boolean centered = false;
        Expression center = op.getArg("center");
        if (center != null) {
            centered = center.evaluateAsBoolean(context);
        }
        return this.factory.createShapeFactory().square(sizeV.x(), sizeV.y(), centered);
    }
}

