/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.construction.SolidFactory;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ModuleExec;
import net.nowina.cadmelia.script.ScriptContext;

public class SphereModule
extends ModuleExec {
    public static final String MODULE_NAME = "sphere";
    private FactoryBuilder factory;

    public SphereModule(FactoryBuilder factory) {
        super(MODULE_NAME);
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Object sphere = null;
        int resolution = 16;
        Expression resolutionExpr = op.getArg("$fa");
        if (resolutionExpr != null) {
            resolution = resolutionExpr.evaluateAsInteger(context);
        }
        double radius = 1.0;
        Expression sizeExpr = op.getArg("r");
        if (sizeExpr != null) {
            radius = sizeExpr.evaluateAsDouble(context);
        } else {
            sizeExpr = op.getFirstUnamedArg();
            if (sizeExpr != null) {
                radius = sizeExpr.evaluateAsDouble(context);
            }
        }
        SolidFactory builder = this.factory.createSolidFactory();
        return builder.sphere(radius, resolution, resolution / 2);
    }
}

