/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScaleModule.class);
    public static final String MODULE_NAME = "scale";
    public static final String VECTOR_PARAM = "v";

    public ScaleModule() {
        super(MODULE_NAME);
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Construction composition = super.execute(op, context);
        Expression scaleExpr = op.getArg(VECTOR_PARAM);
        if (scaleExpr == null) {
            scaleExpr = op.getFirstUnamedArg();
        }
        if (scaleExpr == null) {
            throw new NullPointerException("a scale vector must be provided");
        }
        Literal value = scaleExpr.evaluate(context);
        Vector scale = null;
        if (value.isVector()) {
            scale = value.asVector();
        } else {
            double d = value.asDouble();
            scale = new Vector(d, d, d);
        }
        LOGGER.info("Scale composition of " + scale);
        composition = composition.scale(scale);
        return composition;
    }
}

