/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import java.util.ArrayList;
import java.util.List;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolygonModule.class);
    public static final String MODULE_NAME = "polygon";
    private FactoryBuilder factory;

    public PolygonModule(FactoryBuilder factory) {
        super(MODULE_NAME);
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Expression listExpression = op.getArg("points");
        if (listExpression == null) {
            listExpression = op.getFirstUnamedArg();
        }
        ArrayList<Vector> list = new ArrayList<Vector>();
        Literal points = listExpression.evaluate(context);
        for (Object o : points.asList()) {
            list.add(new Literal(o).asVector());
        }
        return this.polygon(list, context);
    }

    private Construction polygon(List<Vector> list, ScriptContext context) {
        return this.factory.createShapeFactory().polygon(list);
    }
}

