/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinearExtrudeModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinearExtrudeModule.class);
    public static final String MODULE_NAME = "linear_extrude";
    public static final String HEIGHT_PARAM = "height";
    public static final String SCALE_PARAM = "scale";
    private FactoryBuilder factory;

    public LinearExtrudeModule(FactoryBuilder factory) {
        super(MODULE_NAME);
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        Construction composition = super.execute(op, context);
        if (composition == null) {
            LOGGER.warn("Cannot extrude null shape");
            return null;
        }
        if (!composition.isShape()) {
            LOGGER.warn("Extruded construction must be a Shape");
            return composition;
        }
        Expression expH = op.getArg(HEIGHT_PARAM);
        if (expH == null) {
            expH = op.getFirstUnamedArg();
        }
        if (expH == null) {
            throw new IllegalArgumentException("Parameter 'height' is not defined");
        }
        double height = expH.evaluateAsDouble(context);
        double scale = 1.0;
        Expression scaleExpr = op.getArg(SCALE_PARAM);
        if (scaleExpr != null) {
            scale = scaleExpr.evaluateAsDouble(context);
        }
        return this.factory.createSolidFactory().extrude(composition, height, scale);
    }
}

