/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import java.util.ArrayList;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Define;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.IfCommand;
import net.nowina.cadmelia.script.Instruction;
import net.nowina.cadmelia.script.Scope;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfModule.class);
    public static final String MODULE_NAME = "if";

    public IfModule() {
        super(MODULE_NAME);
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        IfCommand ifCommand = (IfCommand)op;
        Expression conditionExpr = ifCommand.getCondition();
        boolean condition = conditionExpr.evaluateAsBoolean(context);
        if (condition) {
            return this.executeInstruction(ifCommand.getThenScope(), context);
        }
        if (ifCommand.getElseScope() != null) {
            return this.executeInstruction(ifCommand.getElseScope(), context);
        }
        return null;
    }

    Construction executeInstruction(Instruction instruction, ScriptContext context) {
        switch (instruction.getType()) {
            case COMMAND: {
                Command command = (Command)instruction;
                return this.operation(command, context);
            }
            case SCOPE: {
                Scope scope = (Scope)instruction;
                ScriptContext thisScope = new ScriptContext(context);
                ArrayList<Command> operations = new ArrayList<Command>();
                block8: for (Instruction i : scope.getInstructions()) {
                    switch (i.getType()) {
                        case DEFINE: {
                            Define define = (Define)i;
                            thisScope.defineVariableValue(define.getName(), define.getExpression());
                            continue block8;
                        }
                        case COMMAND: {
                            operations.add((Command)i);
                            continue block8;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected type " + (Object)((Object)i.getType()));
                }
                return super.union(operations, thisScope);
            }
        }
        throw new IllegalStateException();
    }
}

