/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import java.util.ArrayList;
import java.util.List;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Define;
import net.nowina.cadmelia.script.ForCommand;
import net.nowina.cadmelia.script.Instruction;
import net.nowina.cadmelia.script.Iteration;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.Scope;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForModule
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForModule.class);
    public static final String MODULE_NAME = "for";

    public ForModule() {
        super(MODULE_NAME);
    }

    @Override
    public Construction execute(Command _op, ScriptContext context) {
        ForCommand op = (ForCommand)_op;
        Construction iteration = null;
        List<Iteration> iterations = op.getIterations();
        iteration = this.executeIteration(context, op, iteration, iterations, 0);
        return iteration;
    }

    Construction executeIteration(ScriptContext context, ForCommand op, Construction iteration, List<Iteration> iterations, int index) {
        if (iterations.size() > index) {
            Iteration it = iterations.get(index);
            Literal iterable = it.getIterableDef().evaluate(context);
            for (Object val : iterable.asList()) {
                ScriptContext childContext = new ScriptContext(context);
                childContext.defineVariableValue(it.getVariable(), val);
                LOGGER.info("ForCommand " + it.getVariable() + "=" + val);
                iteration = this.executeIteration(childContext, op, iteration, iterations, index + 1);
            }
            LOGGER.info("Return " + it.getVariable());
            return iteration;
        }
        Instruction instruction = op.getInstruction();
        switch (instruction.getType()) {
            case SCOPE: {
                iteration = this.executeScope(iteration, context, (Scope)instruction);
                break;
            }
            case COMMAND: {
                iteration = this.executeCommand(iteration, context, (Command)instruction);
            }
        }
        LOGGER.info("Result of this iteration " + iteration);
        return iteration;
    }

    private Construction executeScope(Construction iteration, ScriptContext childContext, Scope instruction) {
        Scope scope = instruction;
        ArrayList<Command> operations = new ArrayList<Command>();
        block4: for (Instruction instr : scope.getInstructions()) {
            switch (instr.getType()) {
                case DEFINE: {
                    Define define = (Define)instr;
                    childContext.defineVariableValue(define.getName(), define.getExpression());
                    continue block4;
                }
                case COMMAND: {
                    operations.add((Command)instr);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected type " + (Object)((Object)instr.getType()));
        }
        for (Command internal : operations) {
            Construction element = this.operation(internal, childContext);
            if (element == null) {
                LOGGER.warn("Null returned by " + internal);
                continue;
            }
            if (iteration == null) {
                iteration = element;
                continue;
            }
            iteration = iteration.union(element);
        }
        return iteration;
    }

    private Construction executeCommand(Construction iteration, ScriptContext childContext, Command internal) {
        Construction element = this.operation(internal, childContext);
        if (element == null) {
            LOGGER.warn("Null returned by " + internal);
        } else {
            iteration = iteration == null ? element : iteration.union(element);
        }
        return iteration;
    }
}

