/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.CompositionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferenceModule
extends CompositionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DifferenceModule.class);
    public static final String MODULE_NAME = "difference";

    public DifferenceModule() {
        super(MODULE_NAME);
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        return this.difference(op, context);
    }

    private Construction difference(Command transformation, ScriptContext context) {
        Construction composition = null;
        for (Command op : transformation.getOperations()) {
            LOGGER.info("Operation is " + op);
            Construction element = this.operation(op, context);
            if (element == null) {
                LOGGER.warn("Null returned by " + op);
                continue;
            }
            if (composition == null) {
                LOGGER.info("First element of difference");
                composition = element;
                continue;
            }
            LOGGER.info("Difference of composition");
            composition = composition.difference(element);
        }
        return composition;
    }
}

