/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.module;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.construction.SolidFactory;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ModuleExec;
import net.nowina.cadmelia.script.ScriptContext;

public class CubeModule
extends ModuleExec {
    public static final String PARAM_SIZE = "size";
    private FactoryBuilder factory;

    public CubeModule(FactoryBuilder factory) {
        super("cube");
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        SolidFactory builder = this.factory.createSolidFactory();
        Vector sizeVector = new Vector(1.0, 1.0, 1.0);
        Expression unamedSize = op.getFirstUnamedArg();
        if (unamedSize != null) {
            Literal sizeParam = unamedSize.evaluate(context);
            if (sizeParam.isDouble()) {
                double sizeDouble = sizeParam.asDouble();
                sizeVector = new Vector(sizeDouble, sizeDouble, sizeDouble);
            } else {
                sizeVector = sizeParam.asVector();
            }
        } else {
            Expression size = op.getArg(PARAM_SIZE);
            if (size != null) {
                Literal sizeParam = size.evaluate(context);
                if (sizeParam.isDouble()) {
                    double sizeDouble = sizeParam.asDouble();
                    sizeVector = new Vector(sizeDouble, sizeDouble, sizeDouble);
                } else {
                    sizeVector = sizeParam.asVector();
                }
            }
        }
        boolean centered = false;
        Expression center = op.getArg("center");
        if (center == null) {
            center = op.getArg(1);
        }
        if (center != null) {
            centered = center.evaluateAsBoolean(context);
        }
        return builder.cube(sizeVector.x(), sizeVector.y(), sizeVector.z(), centered);
    }
}

