/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.expression;

import java.util.ArrayList;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.IterableDef;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;

public class ListExpression
extends Expression {
    final IterableDef iterableDef;

    public ListExpression(IterableDef iterableDef) {
        this.iterableDef = iterableDef;
    }

    @Override
    protected Object doEvaluation(ScriptContext scriptContext) {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterable<Expression> iterable = this.iterableDef.iterable(scriptContext);
        for (Expression e : iterable) {
            if (e == null) {
                throw new NullPointerException("An element of the list is null ?!");
            }
            Literal evaluate = e.evaluate(scriptContext);
            if (evaluate == null) {
                throw new NullPointerException("Evaluation of " + evaluate + " is null");
            }
            values.add(evaluate.getValue());
        }
        return values;
    }

    public String toString() {
        return this.iterableDef != null ? this.iterableDef.toString() : null;
    }
}

