/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.expression;

import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ScriptContext;

public class InlineIfExpression
extends Expression {
    private Expression condition;
    private Expression thenExpr;
    private Expression elseExpr;

    public InlineIfExpression(Expression condition, Expression thenExpr, Expression elseExpr) {
        this.condition = condition;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    @Override
    protected Object doEvaluation(ScriptContext scriptContext) {
        if (this.condition.evaluateAsBoolean(scriptContext)) {
            return this.thenExpr.evaluate(scriptContext).getValue();
        }
        return this.elseExpr.evaluate(scriptContext).getValue();
    }

    public String toString() {
        return this.condition + "?" + this.thenExpr + ":" + this.elseExpr;
    }

    public Expression getElseExpr() {
        return this.elseExpr;
    }

    public Expression getThenExpr() {
        return this.thenExpr;
    }

    public Expression getCondition() {
        return this.condition;
    }
}

