/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.expression;

import java.util.Arrays;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.Evaluator;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Function;
import net.nowina.cadmelia.script.Parameter;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.evaluator.LookupEvaluator;
import net.nowina.cadmelia.script.evaluator.MaxEvaluator;
import net.nowina.cadmelia.script.evaluator.MinEvaluator;
import net.nowina.cadmelia.script.evaluator.RandEvaluator;
import net.nowina.cadmelia.script.evaluator.RandsEvaluator;
import net.nowina.cadmelia.script.evaluator.SimpleFunctionEvaluator;
import net.nowina.cadmelia.script.evaluator.StrEvaluator;
import net.nowina.cadmelia.script.evaluator.TwoArgsFunctionEvaluator;
import net.nowina.cadmelia.script.evaluator.VersionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionExpression
extends Expression {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionExpression.class);
    private Command command;

    public FunctionExpression(Command command) {
        this.command = command;
    }

    @Override
    protected Object doEvaluation(ScriptContext scriptContext) {
        try {
            return FunctionExpression.evaluateFunction(this.command, scriptContext);
        }
        catch (ClassCastException ex) {
            LOGGER.info("Cannot evaluate the function " + this.command + " : " + ex.getMessage());
            throw ex;
        }
    }

    public static Object evaluateFunction(Command command, ScriptContext context) {
        Evaluator builtInEvaluator = FunctionExpression.getEvaluator(command.getName());
        if (builtInEvaluator != null) {
            return builtInEvaluator.evaluate(command, context);
        }
        return FunctionExpression.evaluateFunctionDef(command, context);
    }

    public static Evaluator getEvaluator(String name) {
        switch (name) {
            case "8bit_polyfont": {
                return new Evaluator(){

                    @Override
                    public Object evaluate(Command command, ScriptContext context) {
                        return Arrays.asList(Arrays.asList(0, 0, 0), Arrays.asList(0, 0, 0));
                    }
                };
            }
            case "abs": {
                return new SimpleFunctionEvaluator(a -> Math.abs(a));
            }
            case "acos": {
                return new SimpleFunctionEvaluator(a -> Math.toDegrees(Math.acos(a)));
            }
            case "asin": {
                return new SimpleFunctionEvaluator(a -> Math.toDegrees(Math.asin(a)));
            }
            case "atan": {
                return new SimpleFunctionEvaluator(a -> Math.toDegrees(Math.atan(a)));
            }
            case "atan2": {
                return new TwoArgsFunctionEvaluator((a, b) -> Math.toDegrees(Math.atan2(a, b)));
            }
            case "ceil": {
                return new SimpleFunctionEvaluator(a -> Math.ceil(a));
            }
            case "cos": {
                return new SimpleFunctionEvaluator(a -> Math.cos(Math.toRadians(a)));
            }
            case "dxf_dim": 
            case "dxf_cross": {
                return new Evaluator(){

                    @Override
                    public Object evaluate(Command command, ScriptContext context) {
                        return 0.0;
                    }
                };
            }
            case "len": {
                return new Evaluator(){

                    @Override
                    public Object evaluate(Command command, ScriptContext context) {
                        return 0.0;
                    }
                };
            }
            case "lookup": {
                return new LookupEvaluator();
            }
            case "max": {
                return new MaxEvaluator();
            }
            case "min": {
                return new MinEvaluator();
            }
            case "rand": {
                return new RandEvaluator();
            }
            case "rands": {
                return new RandsEvaluator();
            }
            case "round": {
                return new SimpleFunctionEvaluator(value -> Math.round(value));
            }
            case "sin": {
                return new SimpleFunctionEvaluator(a -> Math.sin(Math.toRadians(a)));
            }
            case "sqrt": {
                return new SimpleFunctionEvaluator(value -> Math.sqrt(value));
            }
            case "str": {
                return new StrEvaluator();
            }
            case "tan": {
                return new SimpleFunctionEvaluator(a -> Math.tan(Math.toRadians(a)));
            }
            case "version": {
                return new VersionEvaluator();
            }
        }
        return null;
    }

    private static Object evaluateFunctionDef(Command command, ScriptContext context) {
        Function fun = context.getFunction(command.getName());
        if (fun == null) {
            throw new UnsupportedOperationException("Function not recognized " + command.getName());
        }
        ScriptContext childContext = new ScriptContext(context);
        LOGGER.info("Execution of evaluator " + command.getName());
        for (int i = 0; i < fun.getArgs().size(); ++i) {
            Expression argumentValue;
            Parameter param = fun.getArgs().get(i);
            String name = param.getName();
            Expression valueExpr = param.getDefaultValue();
            Object value = null;
            if (valueExpr != null) {
                value = valueExpr._evaluate(context);
            }
            LOGGER.info("Received param " + name + " with default value " + value);
            boolean unamed = i <= command.getUnamedArgCount();
            Expression expression = argumentValue = unamed ? command.getArg(i) : command.getArg(name);
            if (argumentValue != null) {
                value = argumentValue.evaluate(context).getValue();
                LOGGER.info("Param " + name + " is overrided by param " + value);
            }
            childContext.defineVariableValue(name, value);
        }
        Expression exp = fun.getExpression();
        return exp.evaluate(childContext).getValue();
    }

    public String toString() {
        return this.command.toString();
    }
}

