/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script.expression;

import java.util.ArrayList;
import java.util.List;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.expression.TwoArgsFunction;

public class BinaryExpression
extends Expression {
    final Expression xExpr;
    final Expression yExpr;
    final TwoArgsFunction<Double, Double, Double> function;

    public BinaryExpression(Expression xExpr, Expression yExpr, TwoArgsFunction<Double, Double, Double> function) {
        this.xExpr = xExpr;
        this.yExpr = yExpr;
        this.function = function;
    }

    @Override
    protected Object doEvaluation(ScriptContext context) {
        Literal x = this.xExpr.evaluate(context);
        Literal y = this.yExpr.evaluate(context);
        if (x.isList() && y.isList()) {
            List listX = x.asList();
            List listY = y.asList();
            if (listX.size() != listY.size()) {
                throw new IllegalArgumentException("Only list of same size");
            }
            ArrayList<Double> result = new ArrayList<Double>();
            for (int i = 0; i < listX.size(); ++i) {
                Double valX = (Double)listX.get(i);
                Double valY = (Double)listY.get(i);
                result.add(this.function.apply(valX, valY));
            }
            return result;
        }
        if (x.isList()) {
            List doubleList = x.asList();
            Double factor = y.asDouble();
            return this.applyFunctionOnList(doubleList, factor);
        }
        if (y.isList()) {
            List doubleList = y.asList();
            Double factor = x.asDouble();
            return this.applyFunctionOnList(doubleList, factor);
        }
        return this.function.apply(x.asDouble(), y.asDouble());
    }

    private List<Double> applyFunctionOnList(List<Double> doubleList, Double factor) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Double e : doubleList) {
            list.add(this.function.apply(factor, e));
        }
        return list;
    }
}

