/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.CommandInterpreter;
import net.nowina.cadmelia.script.Define;
import net.nowina.cadmelia.script.Function;
import net.nowina.cadmelia.script.Instruction;
import net.nowina.cadmelia.script.InstructionType;
import net.nowina.cadmelia.script.Module;
import net.nowina.cadmelia.script.Script;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.ScriptModule;
import net.nowina.cadmelia.script.module.ChildrenModule;
import net.nowina.cadmelia.script.module.CircleModule;
import net.nowina.cadmelia.script.module.ColorModule;
import net.nowina.cadmelia.script.module.CubeModule;
import net.nowina.cadmelia.script.module.CylinderModule;
import net.nowina.cadmelia.script.module.DifferenceModule;
import net.nowina.cadmelia.script.module.EchoModule;
import net.nowina.cadmelia.script.module.ForModule;
import net.nowina.cadmelia.script.module.HullModule;
import net.nowina.cadmelia.script.module.IfModule;
import net.nowina.cadmelia.script.module.ImportModule;
import net.nowina.cadmelia.script.module.IntersectionForModule;
import net.nowina.cadmelia.script.module.IntersectionModule;
import net.nowina.cadmelia.script.module.LinearExtrudeModule;
import net.nowina.cadmelia.script.module.MultMatrixModule;
import net.nowina.cadmelia.script.module.OffsetModule;
import net.nowina.cadmelia.script.module.PolygonModule;
import net.nowina.cadmelia.script.module.PolyhedronModule;
import net.nowina.cadmelia.script.module.ProjectionModule;
import net.nowina.cadmelia.script.module.RenderModule;
import net.nowina.cadmelia.script.module.RotateExtrudeModule;
import net.nowina.cadmelia.script.module.RotateModule;
import net.nowina.cadmelia.script.module.ScaleModule;
import net.nowina.cadmelia.script.module.SphereModule;
import net.nowina.cadmelia.script.module.SquareModule;
import net.nowina.cadmelia.script.module.SurfaceModule;
import net.nowina.cadmelia.script.module.TextModule;
import net.nowina.cadmelia.script.module.TranslateModule;
import net.nowina.cadmelia.script.module.UnionModule;

public class ScriptScene
extends CommandInterpreter {
    private FactoryBuilder factory;

    public ScriptScene(FactoryBuilder factory) {
        this(false, factory);
    }

    public ScriptScene(boolean preview, FactoryBuilder factory) {
        super(preview, new ScriptContext(), factory);
        this.factory = factory;
        this.getContext().registerModule(new ChildrenModule());
        this.getContext().registerModule(new CircleModule(factory));
        this.getContext().registerModule(new CubeModule(factory));
        this.getContext().registerModule(new CylinderModule(factory));
        this.getContext().registerModule(new ColorModule());
        this.getContext().registerModule(new DifferenceModule());
        this.getContext().registerModule(new EchoModule());
        this.getContext().registerModule(new ForModule());
        this.getContext().registerModule(new LinearExtrudeModule(factory));
        this.getContext().registerModule(new HullModule(factory));
        this.getContext().registerModule(new IfModule());
        this.getContext().registerModule(new ImportModule());
        this.getContext().registerModule(new IntersectionModule());
        this.getContext().registerModule(new IntersectionForModule());
        this.getContext().registerModule(new MultMatrixModule());
        this.getContext().registerModule(new OffsetModule(factory));
        this.getContext().registerModule(new ProjectionModule());
        this.getContext().registerModule(new PolygonModule(factory));
        this.getContext().registerModule(new PolyhedronModule(factory));
        this.getContext().registerModule(new RenderModule());
        this.getContext().registerModule(new RotateModule());
        this.getContext().registerModule(new RotateExtrudeModule());
        this.getContext().registerModule(new ScaleModule());
        this.getContext().registerModule(new SphereModule(factory));
        this.getContext().registerModule(new SquareModule(factory));
        this.getContext().registerModule(new SurfaceModule());
        this.getContext().registerModule(new TextModule(factory));
        this.getContext().registerModule(new TranslateModule());
        this.getContext().registerModule(new UnionModule());
    }

    public void executeScript(Script script) {
        for (Module module : script.getModules()) {
            this.getContext().registerModule(new ScriptModule(module, this.isPreview(), this.factory));
        }
        for (Instruction instruction : script.getInstructions()) {
            if (instruction.getType() != InstructionType.FUNCTION) continue;
            Function fun = (Function)instruction;
            this.getContext().registerFunction(fun);
        }
        for (Instruction instruction : script.getInstructions()) {
            if (instruction.getType() != InstructionType.DEFINE) continue;
            Define define = (Define)instruction;
            Object value = define.getExpression().evaluate(this.getContext()).getValue();
            this.getContext().defineVariableValue(define.getName(), value);
        }
        for (Instruction instruction : script.getInstructions()) {
            if (instruction.getType() != InstructionType.COMMAND) continue;
            Command command = (Command)instruction;
            this.execute(command);
        }
    }
}

