/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.List;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.CommandInterpreter;
import net.nowina.cadmelia.script.Define;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Function;
import net.nowina.cadmelia.script.Instruction;
import net.nowina.cadmelia.script.InstructionType;
import net.nowina.cadmelia.script.Module;
import net.nowina.cadmelia.script.ModuleExec;
import net.nowina.cadmelia.script.Parameter;
import net.nowina.cadmelia.script.ScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptModule
extends ModuleExec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptModule.class);
    private Module module;
    private boolean preview;
    private FactoryBuilder factory;

    public ScriptModule(Module module, boolean preview, FactoryBuilder factory) {
        super(module.getName());
        this.module = module;
        this.preview = preview;
        this.factory = factory;
    }

    @Override
    public Construction execute(Command op, ScriptContext context) {
        ScriptContext childContext = this.populateContext(op, context);
        CommandInterpreter builder = new CommandInterpreter(this.preview, childContext, this.factory);
        block6: for (Instruction i : this.module.getInstructions()) {
            switch (i.getType()) {
                case MODULE: {
                    Module module = (Module)i;
                    childContext.registerModule(new ScriptModule(module, this.preview, this.factory));
                    continue block6;
                }
                case DEFINE: {
                    Define define = (Define)i;
                    Object value = define.getExpression().evaluate(childContext).getValue();
                    childContext.defineVariableValue(define.getName(), value);
                    continue block6;
                }
                case COMMAND: {
                    continue block6;
                }
                case FUNCTION: {
                    Function fun = (Function)i;
                    childContext.registerFunction(fun);
                    continue block6;
                }
            }
            LOGGER.warn("Instruction of type " + (Object)((Object)i.getType()) + " is not recognized");
        }
        for (Instruction i : this.module.getInstructions()) {
            if (i.getType() != InstructionType.COMMAND) continue;
            builder.execute((Command)i);
        }
        return builder.getRoot();
    }

    ScriptContext populateContext(Command op, ScriptContext parentContext) {
        ScriptContext childContext = new ScriptContext(parentContext);
        List<Parameter> parameters = this.module.getParameters();
        LOGGER.info("Execution of module " + op.getName());
        for (int i = 0; i < parameters.size(); ++i) {
            Expression argumentValue;
            Parameter param = parameters.get(i);
            String name = param.getName();
            Expression valueExpr = param.getDefaultValue();
            Object value = null;
            if (valueExpr != null) {
                value = valueExpr._evaluate(parentContext);
            }
            LOGGER.info("Received param " + name + " with default value " + value);
            boolean unamed = i <= op.getUnamedArgCount();
            Expression expression = argumentValue = unamed ? op.getArg(i) : op.getArg(name);
            if (argumentValue != null) {
                value = argumentValue.evaluate(parentContext).getValue();
                LOGGER.info("Param " + name + " is overrided by param " + value);
            }
            childContext.defineVariableValue(name, value);
        }
        return childContext;
    }
}

