/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.HashMap;
import java.util.Map;
import net.nowina.cadmelia.script.ExpressionBuilder;
import net.nowina.cadmelia.script.Function;
import net.nowina.cadmelia.script.ModuleExec;

public class ScriptContext {
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, ModuleExec> modules = new HashMap<String, ModuleExec>();
    private Map<String, Function> functions = new HashMap<String, Function>();
    private final ScriptContext parent;

    public ScriptContext() {
        this.parent = null;
    }

    public ScriptContext(ScriptContext parent) {
        this.parent = parent;
    }

    public Object getVariableValue(String variable) {
        if ("$children".equals(variable)) {
            return ExpressionBuilder.element(0.0);
        }
        if ("$t".equals(variable)) {
            return ExpressionBuilder.element(0.0);
        }
        Object local = this.variables.get(variable);
        if (local == null && this.parent != null) {
            return this.parent.getVariableValue(variable);
        }
        return local;
    }

    public void defineVariableValue(String variable, Object valueOrExpr) {
        if (this.variables.containsKey(variable)) {
            throw new IllegalStateException("Variable '" + variable + "' already defined");
        }
        this.variables.put(variable, valueOrExpr);
    }

    public void registerModule(ModuleExec module) {
        this.modules.put(module.getName(), module);
    }

    public void registerFunction(Function fun) {
        this.functions.put(fun.getName(), fun);
    }

    public ModuleExec getModule(String moduleName) {
        ModuleExec exec = this.modules.get(moduleName);
        if (exec == null && this.parent != null) {
            return this.parent.getModule(moduleName);
        }
        return exec;
    }

    public Function getFunction(String functionName) {
        Function exec = this.functions.get(functionName);
        if (exec == null && this.parent != null) {
            return this.parent.getFunction(functionName);
        }
        return exec;
    }
}

