/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ExpressionBuilder;
import net.nowina.cadmelia.script.IterableDef;
import net.nowina.cadmelia.script.Range;
import net.nowina.cadmelia.script.ScriptContext;

public class RangeIterableDef
extends IterableDef {
    private static final Expression DEFAULT_INCREMENT = ExpressionBuilder.element(1.0);
    private final Expression start;
    private final Expression end;
    private final Expression increment;

    public RangeIterableDef(Expression start, Expression end, Expression increment) {
        this.start = start;
        this.end = end;
        this.increment = increment != null ? increment : DEFAULT_INCREMENT;
    }

    public RangeIterableDef(Expression start, Expression end) {
        this(start, end, DEFAULT_INCREMENT);
    }

    @Override
    public Iterable<Expression> iterable(ScriptContext ctx) {
        double start = this.start.evaluateAsDouble(ctx);
        double end = this.end.evaluateAsDouble(ctx);
        double increment = this.increment.evaluateAsDouble(ctx);
        return new Range(start, end, increment);
    }
}

