/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.Iterator;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.ExpressionBuilder;

public class Range
implements Iterable<Expression> {
    private final double start;
    private final double end;
    private final double increment;

    public Range(double start, double end, double increment) {
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Iterator<Expression> iterator() {
        return new RangeIterator();
    }

    class RangeIterator
    implements Iterator<Expression> {
        private double value;

        RangeIterator() {
            this.value = Range.this.start;
        }

        @Override
        public boolean hasNext() {
            return this.value <= Range.this.end;
        }

        @Override
        public Expression next() {
            double current = this.value;
            this.value += Range.this.increment;
            return ExpressionBuilder.element(current);
        }
    }
}

