/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.Arrays;
import java.util.List;
import net.nowina.cadmelia.construction.Vector;

public class Literal {
    private Object value;

    public Literal(Object value) {
        if (value == null) {
            throw new NullPointerException("Value must be defined");
        }
        this.value = value instanceof Literal ? ((Literal)value).getValue() : value;
    }

    public String toString() {
        return this.value.toString();
    }

    public Double asDouble() {
        if (this.isInteger()) {
            return new Double(((Integer)this.value).intValue());
        }
        return (Double)this.value;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public List asList() {
        if (this.value instanceof Vector) {
            Vector v = (Vector)this.value;
            return Arrays.asList(v.x(), v.y(), v.z());
        }
        return (List)this.value;
    }

    public boolean isList() {
        return this.value instanceof List;
    }

    public Integer asInteger() {
        if (this.isDouble()) {
            return ((Double)this.value).intValue();
        }
        return (Integer)this.value;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public Boolean asBoolean() {
        return (Boolean)this.value;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public String asString() {
        return (String)this.value;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public Vector asVector() {
        if (this.asList().size() == 3) {
            return new Vector(((Double)this.asList().get(0)).doubleValue(), ((Double)this.asList().get(1)).doubleValue(), ((Double)this.asList().get(2)).doubleValue());
        }
        if (this.asList().size() == 2) {
            return new Vector(((Double)this.asList().get(0)).doubleValue(), ((Double)this.asList().get(1)).doubleValue());
        }
        throw new IllegalArgumentException("Cannot convert list of " + this.asList().size() + " elements in a Vector");
    }

    public boolean isVector() {
        return this.isList() && (this.asList().size() == 2 || this.asList().size() == 3);
    }

    public Object getValue() {
        return this.value;
    }
}

