/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.IterableDef;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;

public class ListIterableDef
extends IterableDef {
    private final List<Expression> list;

    public ListIterableDef(List<Expression> list) {
        this.list = list;
    }

    public ListIterableDef() {
        this(new ArrayList<Expression>());
    }

    public ListIterableDef(Expression ... list) {
        this(Arrays.asList(list));
    }

    public void add(Expression exp) {
        this.list.add(exp);
    }

    @Override
    public Iterable<Expression> iterable(ScriptContext ctx) {
        return this.list;
    }

    @Override
    protected Object doEvaluation(ScriptContext context) {
        ArrayList<Literal> list = new ArrayList<Literal>();
        for (Expression e : this.iterable(context)) {
            list.add(e.evaluate(context));
        }
        return list;
    }
}

