/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.List;
import net.nowina.cadmelia.construction.Vector;
import net.nowina.cadmelia.script.Literal;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.expression.BinaryExpression;
import net.nowina.cadmelia.script.expression.ComparisonExpression;
import net.nowina.cadmelia.script.expression.NegExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Expression {
    private static final Logger LOGGER = LoggerFactory.getLogger(Expression.class);

    public final Literal evaluate(ScriptContext context) {
        try {
            Object value = this._evaluate(context);
            return new Literal(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Cannot evaluate expression " + this + ": " + e.getMessage());
            throw e;
        }
    }

    public final Object _evaluate(ScriptContext context) {
        Object value = this.doEvaluation(context);
        while (value instanceof Expression) {
            value = ((Expression)value).doEvaluation(context);
        }
        if (value == null) {
            throw new NullPointerException("Cannot evaluate a null value");
        }
        return value;
    }

    protected abstract Object doEvaluation(ScriptContext var1);

    public boolean evaluateAsBoolean(ScriptContext context) {
        return (Boolean)this._evaluate(context);
    }

    public String evaluateAsString(ScriptContext context) {
        return (String)this._evaluate(context);
    }

    public Double evaluateAsDouble(ScriptContext context) {
        Object value = this._evaluate(context);
        if (value instanceof Integer) {
            return new Double(((Integer)value).intValue());
        }
        return (Double)value;
    }

    public int evaluateAsInteger(ScriptContext context) {
        return ((Double)this._evaluate(context)).intValue();
    }

    public List evaluateAsList(ScriptContext context) {
        return (List)this._evaluate(context);
    }

    public Vector evaluateAsVector(ScriptContext context) {
        List list = this.evaluateAsList(context);
        if (list.size() == 2) {
            double x = (Double)list.get(0);
            double y = (Double)list.get(1);
            return new Vector(x, y);
        }
        if (list.size() == 3) {
            double x = (Double)list.get(0);
            double y = (Double)list.get(1);
            double z = (Double)list.get(2);
            return new Vector(x, y, z);
        }
        throw new IllegalStateException("Cannot make a vector out of " + list.size() + " elements");
    }

    public Expression neg() {
        return new NegExpression(this);
    }

    public Expression times(Expression arg) {
        return new BinaryExpression(this, arg, (x, y) -> x * y);
    }

    public Expression divide(Expression arg) {
        return new BinaryExpression(this, arg, (x, y) -> x / y);
    }

    public Expression plus(Expression arg) {
        return new BinaryExpression(this, arg, (x, y) -> x + y);
    }

    public Expression minus(Expression arg) {
        return new BinaryExpression(this, arg, (x, y) -> x - y);
    }

    public Expression modulo(Expression arg) {
        return new BinaryExpression(this, arg, (x, y) -> x % y);
    }

    public Expression booleanEquals(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> x != null ? x.equals(y) : y == null);
    }

    public Expression booleanNotEquals(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> x != null ? !x.equals(y) : y != null);
    }

    public Expression greaterThan(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> (Double)x > (Double)y);
    }

    public Expression lowerThan(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> (Double)x < (Double)y);
    }

    public Expression greaterOrEqualThan(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> (Double)x >= (Double)y);
    }

    public Expression lowerOrEqualThan(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> (Double)x <= (Double)y);
    }

    public Expression or2(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> this.asBoolean(x) != false || this.asBoolean(y) != false);
    }

    public Expression and2(Expression arg) {
        return new ComparisonExpression(this, arg, (x, y) -> this.asBoolean(x) != false && this.asBoolean(y) != false);
    }

    public Boolean asBoolean(Object val) {
        if (val instanceof Double) {
            Double d = (Double)val;
            if (d == 0.0 || d == 0.0) {
                return false;
            }
            return true;
        }
        return (Boolean)val;
    }
}

