/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.FactoryBuilder;
import net.nowina.cadmelia.script.Command;
import net.nowina.cadmelia.script.ScriptContext;
import net.nowina.cadmelia.script.module.UnionModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandInterpreter
extends UnionModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandInterpreter.class);
    private final boolean preview;
    private final ScriptContext context;
    private Construction root;
    private FactoryBuilder factory;

    public CommandInterpreter(boolean preview, ScriptContext context, FactoryBuilder factory) {
        this.factory = factory;
        this.preview = preview;
        this.context = context;
    }

    public void execute(Command command) {
        LOGGER.info("New command " + command);
        Construction element = this.operation(command, this.context);
        if (this.root == null) {
            this.root = element;
        } else if (element != null) {
            this.root = this.root.union(element);
        }
    }

    public Construction getRoot() {
        return this.root;
    }

    public ScriptContext getContext() {
        return this.context;
    }

    public boolean isPreview() {
        return this.preview;
    }
}

