/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.script;

import java.util.ArrayList;
import java.util.List;
import net.nowina.cadmelia.script.Argument;
import net.nowina.cadmelia.script.Expression;
import net.nowina.cadmelia.script.Instruction;
import net.nowina.cadmelia.script.InstructionType;

public class Command
extends Instruction {
    final String name;
    final List<Argument> args = new ArrayList<Argument>();
    final List<Command> operations = new ArrayList<Command>();

    public Command(String name) {
        super(InstructionType.COMMAND);
        this.name = name;
    }

    public void addArg(Argument arg) {
        this.args.add(arg);
    }

    public void addArg(Expression exp) {
        this.args.add(new Argument(null, exp));
    }

    public Expression getArg(String name) {
        for (Argument arg : this.args) {
            if (!name.equals(arg.getName())) continue;
            return arg.getExpression();
        }
        return null;
    }

    public Expression getArg(int index) {
        if (index >= this.args.size()) {
            return null;
        }
        return this.args.get(index).getExpression();
    }

    public Expression getFirstUnamedArg() {
        for (Argument arg : this.args) {
            if (arg.getName() != null) continue;
            return arg.getExpression();
        }
        return null;
    }

    public int getArgCount() {
        return this.args.size();
    }

    public int getUnamedArgCount() {
        int count = 0;
        for (Argument arg : this.args) {
            if (arg.getName() == null) {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }

    public String getName() {
        return this.name;
    }

    public void addOperation(Command operation) {
        this.operations.add(operation);
    }

    public List<Command> getOperations() {
        return this.operations;
    }

    public String toString() {
        return "Command{name='" + this.name + '\'' + ", parameters=" + this.args + '}';
    }
}

