/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.model;

import java.io.PrintWriter;
import java.util.List;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.construction.MeshVisitor;
import net.nowina.cadmelia.construction.PolygonWithHoles;
import net.nowina.cadmelia.construction.Shape;
import net.nowina.cadmelia.construction.Solid;
import net.nowina.cadmelia.math.Transformation;
import net.nowina.cadmelia.model.Difference;
import net.nowina.cadmelia.model.Intersection;
import net.nowina.cadmelia.model.Union;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelConstruction
implements Construction,
Shape,
Solid {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelConstruction.class);
    private Transformation transform;

    public Construction union(Construction other) {
        LOGGER.info("Union of " + this + " with " + other);
        if (other != null) {
            if (this instanceof Union) {
                Union union = (Union)this;
                union.add(other);
                return union;
            }
            Union union = new Union();
            union.add(this);
            union.add(other);
            return union;
        }
        return this;
    }

    public Construction difference(Construction other) {
        if (this instanceof Difference) {
            Difference difference = (Difference)this;
            difference.addElement(other);
            return difference;
        }
        Difference difference = new Difference(this);
        difference.addElement(other);
        return difference;
    }

    public Construction intersection(Construction other) {
        LOGGER.info("Intersection of " + this + " with " + other);
        if (this instanceof Intersection) {
            Intersection intersection = (Intersection)this;
            intersection.add(other);
            return intersection;
        }
        Intersection intersection = new Intersection();
        intersection.add(this);
        intersection.add(other);
        return intersection;
    }

    public Construction transform(Transformation tx) {
        this.apply(tx);
        return this;
    }

    private void apply(Transformation transform) {
        if (this.transform == null) {
            this.transform = transform;
        } else {
            this.transform.apply(transform);
        }
    }

    public void print(PrintWriter writer) {
        this.print(writer, "");
    }

    protected void print(PrintWriter writer, String paddingPrefix) {
        writer.print(paddingPrefix);
        if (this.getTransform() != null) {
            writer.write("Transform{" + this.getTransform() + "} ");
        }
        writer.println(this.toString());
    }

    public abstract boolean isShape();

    public abstract boolean isSolid();

    public void visit(MeshVisitor visitor) {
    }

    public List<PolygonWithHoles> getPolygons() {
        throw new UnsupportedOperationException();
    }

    public Transformation getTransform() {
        return this.transform;
    }
}

