/*
 * Decompiled with CFR 0.152.
 */
package net.nowina.cadmelia.model;

import java.io.PrintWriter;
import net.nowina.cadmelia.construction.Construction;
import net.nowina.cadmelia.model.ModelConstruction;
import net.nowina.cadmelia.model.Union;

public class Difference
extends ModelConstruction {
    private ModelConstruction source;
    private Union union;

    public Difference(ModelConstruction source) {
        this.source = source;
    }

    public void addElement(Construction construction) {
        if (this.union == null) {
            this.union = new Union();
        }
        this.union.add(construction);
    }

    @Override
    public boolean isSolid() {
        if (this.source == null) {
            throw new IllegalStateException();
        }
        return this.source.isSolid();
    }

    @Override
    public boolean isShape() {
        if (this.source == null) {
            throw new IllegalStateException();
        }
        return this.source.isShape();
    }

    @Override
    protected void print(PrintWriter writer, String paddingPrefix) {
        writer.print(paddingPrefix);
        if (this.getTransform() != null) {
            writer.write("Transform{" + this.getTransform() + "} ");
        }
        writer.println("Difference {");
        String padding = paddingPrefix + "  ";
        this.source.print(writer, padding);
        if (this.union != null) {
            for (ModelConstruction c : this.union.getElements()) {
                c.print(writer, padding);
            }
        }
        writer.print(paddingPrefix);
        writer.println("}");
    }
}

