/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import net.northfuse.resources.ResourceHandlerImpl;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public final class ScriptResourceHandler
extends ResourceHandlerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptResourceHandler.class);
    private final ErrorReporter errorReporter = new ErrorReporter(){

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            LOG.warn(this.createMessage(message, sourceName, line, lineSource, lineOffset));
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            LOG.error(this.createMessage(message, sourceName, line, lineSource, lineOffset));
        }

        private String createMessage(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return message + " @" + sourceName + ":" + line + ":" + lineOffset + " - " + lineSource;
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return null;
        }
    };

    public ScriptResourceHandler() {
        super(new MediaType("text", "javascript"));
    }

    @Override
    protected InputStream wrapWithMinify(InputStream is) throws IOException {
        int linebreak = 0;
        boolean munge = true;
        boolean verbose = false;
        boolean preserveAllSemiColons = false;
        boolean disableOptimizations = false;
        InputStreamReader reader = new InputStreamReader(is);
        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)reader, this.errorReporter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        compressor.compress((Writer)writer, linebreak, munge, verbose, preserveAllSemiColons, disableOptimizations);
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

