/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources.config;

import net.northfuse.resources.config.NodeListIterator;
import net.northfuse.resources.config.ResourceDefinitionParser;
import net.northfuse.resources.config.ScriptDefinitionParser;
import net.northfuse.resources.config.StyleDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourcesDefinitionParser
implements BeanDefinitionParser {
    private final ScriptDefinitionParser scriptDefinitionParser;
    private final StyleDefinitionParser styleDefinitionParser;

    public ResourcesDefinitionParser(ScriptDefinitionParser scriptDefinitionParser, StyleDefinitionParser styleDefinitionParser) {
        this.scriptDefinitionParser = scriptDefinitionParser;
        this.styleDefinitionParser = styleDefinitionParser;
    }

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        String debug = element.getAttribute("debug");
        String order = element.getAttribute("order");
        String mapping = element.getAttribute("mapping");
        this.handleElement(element, "script", this.scriptDefinitionParser, parserContext, debug, mapping, order);
        this.handleElement(element, "style", this.styleDefinitionParser, parserContext, debug, mapping, order);
        return null;
    }

    private void handleElement(Element element, String name, ResourceDefinitionParser parser, ParserContext parserContext, String debug, String mapping, String order) {
        NodeList nodeList = element.getElementsByTagNameNS("http://northfuse.net/schema/resources-ext", name);
        for (Element e : new NodeListIterator(nodeList)) {
            parser.doParse(parserContext, e, debug, mapping, order);
        }
    }
}

