/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import net.northfuse.resources.AggregatedResource;
import net.northfuse.resources.ResourceGenerator;
import net.northfuse.resources.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;

public abstract class ResourceHandlerImpl
implements ResourceHandler {
    private String mapping;
    private Resource resource;
    private ResourceGenerator resourceGenerator;
    private boolean debug;
    private final MediaType mediaType;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHandler.class);

    ResourceHandlerImpl(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final boolean isDebug() {
        return this.debug;
    }

    @Override
    public final String getMapping() {
        return this.mapping;
    }

    public final void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public final void setResourceGenerator(ResourceGenerator resourceGenerator) {
        this.resourceGenerator = resourceGenerator;
    }

    @Override
    public final Resource getAggregatedResource() {
        if (this.debug) {
            LOG.debug("Loading resource: " + this.getMapping());
            AggregatedResource resource = this.resourceGenerator.getAggregatedResource(true);
            LOG.debug("Loaded resource: " + this.getMapping());
            return resource;
        }
        return this.resource;
    }

    @PostConstruct
    public final void init() throws IOException {
        if (!this.debug) {
            LOG.info("Initializing resource: " + this.getMapping());
            AggregatedResource resource = this.resourceGenerator.getAggregatedResource(false);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = this.wrapWithMinify(resource.getInputStream());
            FileCopyUtils.copy((InputStream)is, (OutputStream)baos);
            this.resource = new AggregatedResource(baos.toByteArray());
            LOG.info("Initialized Resource: " + this.getMapping());
        }
    }

    protected abstract InputStream wrapWithMinify(InputStream var1) throws IOException;

    @Override
    public final MediaType getMediaType() {
        return this.mediaType;
    }
}

