/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.northfuse.resources.AggregatedResource;
import net.northfuse.resources.LineWrapperInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public final class ResourceGenerator
implements ApplicationContextAware {
    private final List<String> resourcePaths = new LinkedList<String>();
    private ResourcePatternResolver resourceResolver;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceGenerator.class);

    public void setResources(List<String> resources) {
        this.resourcePaths.addAll(resources);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.resourceResolver = applicationContext;
    }

    private List<Resource> resolveResources() {
        LinkedList<Resource> resolvedResources = new LinkedList<Resource>();
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug("resolving resources");
        }
        for (String resourcePath : this.resourcePaths) {
            if (debug) {
                LOG.debug("resolving resource path [" + resourcePath + "]");
            }
            try {
                LinkedList resources = Lists.newLinkedList((Iterable)Iterables.filter(Arrays.asList(this.resourceResolver.getResources(resourcePath)), (Predicate)new Predicate<Resource>(){

                    public boolean apply(Resource input) {
                        return !input.getDescription().contains("webinf");
                    }
                }));
                if (debug) {
                    LOG.debug("Found " + resources.size() + " resources:");
                    for (Resource resource : resources) {
                        LOG.debug("\t" + resource.getDescription());
                    }
                }
                Collections.sort(resources, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        return o1.getDescription().compareTo(o2.getDescription());
                    }
                });
                resolvedResources.addAll(resources);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to get resources for resourcePath [" + resourcePath + "]", e);
            }
        }
        return resolvedResources;
    }

    public AggregatedResource getAggregatedResource(boolean debug) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Resource resource : this.resolveResources()) {
            try {
                LOG.debug("Adding " + resource.getDescription());
                InputStream is = debug ? new LineWrapperInputStream(resource.getInputStream(), resource.getDescription()) : resource.getInputStream();
                FileCopyUtils.copy((InputStream)is, (OutputStream)baos);
                baos.write(10);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to copy resource file [" + resource.getDescription() + "]", e);
            }
        }
        byte[] data = baos.toByteArray();
        LOG.debug("Built resource with " + data.length + " bytes @" + new Date());
        return new AggregatedResource(data);
    }
}

