/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public final class LineWrapperInputStream
extends InputStream {
    private final InputStream is;

    public LineWrapperInputStream(InputStream in, String description) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        int lineNumber = 0;
        boolean inComment = false;
        while ((line = reader.readLine()) != null) {
            int commentIndex;
            if (inComment) {
                writer.println("   " + description + ":" + ++lineNumber + "   " + line);
            } else {
                writer.println("/* " + description + ":" + ++lineNumber + " */" + line);
            }
            if (!inComment) {
                commentIndex = line.lastIndexOf("/*");
                if (commentIndex <= -1 || commentIndex > 0 && this.inString(line.substring(0, commentIndex)) || line.substring(commentIndex).contains("*/") || line.substring(0, commentIndex).contains("//")) continue;
                inComment = true;
                continue;
            }
            commentIndex = line.lastIndexOf("*/");
            if (commentIndex <= -1 || line.substring(commentIndex).contains("/*")) continue;
            inComment = false;
        }
        writer.close();
        byte[] data = baos.toByteArray();
        this.is = new ByteArrayInputStream(data, 0, data.length - 1);
    }

    private boolean inString(String line) {
        return this.countOccurences(line, '\"') % 2 != 0;
    }

    private int countOccurences(String s, char pattern) {
        int count = 0;
        for (char c : s.toCharArray()) {
            if (c != pattern) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.is.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }
}

