/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.northfuse.resources.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.WebContentGenerator;

public final class ResourceHandlerAdapter
extends WebContentGenerator
implements HandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHandlerAdapter.class);

    public ResourceHandlerAdapter() {
        super(new String[]{"GET"});
    }

    public boolean supports(Object handler) {
        return ResourceHandler.class.isAssignableFrom(handler.getClass());
    }

    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        this.checkAndPrepare(request, response, true);
        ResourceHandler handler = (ResourceHandler)o;
        Resource resource = handler.getAggregatedResource();
        MediaType mediaType = handler.getMediaType();
        this.setHeaders(response, resource, mediaType);
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            LOG.debug("Resource not modified - returning 304");
            return null;
        }
        this.writeContent(response, resource);
        return null;
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        response.setContentType(mediaType.toString());
    }

    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
    }
}

