/*
 * Decompiled with CFR 0.152.
 */
package net.northfuse.resources.config;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.northfuse.resources.ResourceGenerator;
import net.northfuse.resources.ResourceHandler;
import net.northfuse.resources.ResourceHandlerAdapter;
import net.northfuse.resources.config.NodeListIterator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

abstract class ResourceDefinitionParser<T extends ResourceHandler>
implements BeanDefinitionParser {
    private final AtomicBoolean registeredAdapter = new AtomicBoolean();
    private final Object lock = new Object();

    ResourceDefinitionParser() {
    }

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        this.doParse(parserContext, element, false, "", "");
        return null;
    }

    public final void doParse(ParserContext parserContext, Element element, boolean defaultDebug, String baseMapping, String defaultOrder) {
        Object source = parserContext.extractSource((Object)element);
        Data data = this.registerResourceHandler(parserContext, element, source, defaultDebug, baseMapping);
        if (data == null) {
            return;
        }
        String resourceMapping = data.resourceMapping;
        String handlerBeanName = data.handlerBeanName;
        this.registerAdapterIfNeeded(parserContext);
        RootBeanDefinition handlerMappingDefinition = new RootBeanDefinition(SimpleUrlHandlerMapping.class);
        handlerMappingDefinition.setSource(source);
        String order = element.getAttribute("order");
        if (!StringUtils.hasText((String)order)) {
            order = StringUtils.hasText((String)defaultOrder) ? defaultOrder : Integer.toString(0x7FFFFFFE);
        }
        handlerMappingDefinition.getPropertyValues().add("order", (Object)order);
        ManagedMap urlMap = new ManagedMap();
        urlMap.put(resourceMapping, handlerBeanName);
        handlerMappingDefinition.getPropertyValues().add("urlMap", (Object)urlMap);
        String handlerMappingBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)handlerMappingDefinition);
        parserContext.getRegistry().registerBeanDefinition(handlerMappingBeanName, (BeanDefinition)handlerMappingDefinition);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)handlerMappingDefinition, handlerMappingBeanName));
    }

    private Data registerResourceHandler(ParserContext parserContext, Element element, Object source, boolean defaultDebug, String baseMapping) {
        RootBeanDefinition handlerDefinition = new RootBeanDefinition(this.getImplementation());
        String debug = element.getAttribute("debug");
        if (!StringUtils.hasText((String)debug)) {
            debug = Boolean.toString(defaultDebug);
        }
        handlerDefinition.getPropertyValues().add("debug", (Object)debug);
        handlerDefinition.setSource(source);
        String resourceMapping = element.getAttribute("mapping");
        if (!StringUtils.hasText((String)resourceMapping)) {
            parserContext.getReaderContext().error("The 'mapping' attribute is required.", parserContext.extractSource((Object)element));
            return null;
        }
        handlerDefinition.getPropertyValues().add("mapping", (Object)(baseMapping + resourceMapping));
        RootBeanDefinition generatorDefinition = new RootBeanDefinition(ResourceGenerator.class.getName());
        generatorDefinition.getPropertyValues().add("resources", this.findLocations(element));
        handlerDefinition.getPropertyValues().add("resourceGenerator", (Object)generatorDefinition);
        String handlerBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)handlerDefinition);
        parserContext.getRegistry().registerBeanDefinition(handlerBeanName, (BeanDefinition)handlerDefinition);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)handlerDefinition, handlerBeanName));
        Data data = new Data();
        data.handlerBeanName = handlerBeanName;
        data.resourceMapping = resourceMapping;
        return data;
    }

    private List<String> findLocations(Element element) {
        LinkedList<String> resources = new LinkedList<String>();
        NodeList nodeList = element.getElementsByTagNameNS("http://northfuse.net/schema/resources-ext", "resource");
        for (Element e : new NodeListIterator(nodeList)) {
            resources.add(e.getAttribute("location"));
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdapterIfNeeded(ParserContext parserContext) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.registeredAdapter.get()) {
                this.registeredAdapter.set(true);
                RootBeanDefinition adapterDefinition = new RootBeanDefinition(ResourceHandlerAdapter.class);
                parserContext.getRegistry().registerBeanDefinition(ResourceHandlerAdapter.class.getName(), (BeanDefinition)adapterDefinition);
            }
        }
    }

    protected abstract Class<T> getImplementation();

    private static class Data {
        private String handlerBeanName;
        private String resourceMapping;

        private Data() {
        }
    }
}

