/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.utils;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlOperations {
    private static final Logger log = LoggerFactory.getLogger(CqlOperations.class);

    public static Consumer<String> execute(CqlSession session) {
        return query -> {
            log.debug("executing : {}", query);
            session.execute(query);
        };
    }

    public static Consumer<String> use(CqlSession session) {
        return keyspace -> {
            ResultSet resultSet = session.execute("USE " + keyspace);
        };
    }

    public static Consumer<String> truncateTable(CqlSession session) {
        return fullyQualifiedTable -> {
            ResultSet resultSet = session.execute("truncate table " + fullyQualifiedTable);
        };
    }

    public static Consumer<String> dropKeyspace(CqlSession session) {
        return keyspace -> CqlOperations.execute(session).accept("DROP KEYSPACE IF EXISTS " + keyspace);
    }

    public static Consumer<String> createKeyspace(CqlSession session) {
        return keyspace -> CqlOperations.execute(session).accept("CREATE KEYSPACE IF NOT EXISTS " + keyspace + " WITH replication={'class' : 'SimpleStrategy', 'replication_factor':1} AND durable_writes = false");
    }
}

