/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.dataset.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleCQLLexer {
    String text;
    LexState state;
    int pos;

    public SimpleCQLLexer(List<String> lines) {
        this.text = lines.stream().map(String::trim).collect(Collectors.joining("\n"));
        this.pos = 0;
        this.state = LexState.DEFAULT;
    }

    char getChar() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos++);
        }
        return '\u0000';
    }

    char peekAhead() {
        if (this.pos < this.text.length()) {
            return this.text.charAt(this.pos);
        }
        return '\u0000';
    }

    void advance() {
        ++this.pos;
    }

    List<String> getStatements() {
        char c;
        ArrayList<String> statements = new ArrayList<String>();
        StringBuilder statementUnderConstruction = new StringBuilder();
        block7: while ((c = this.getChar()) != '\u0000') {
            switch (this.state) {
                case DEFAULT: {
                    if (c == '/' && this.peekAhead() == '/') {
                        this.state = LexState.INSINGLELINECOMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '-' && this.peekAhead() == '-') {
                        this.state = LexState.INSINGLELINECOMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '/' && this.peekAhead() == '*') {
                        this.state = LexState.INMULTILINECOMMENT;
                        this.advance();
                        break;
                    }
                    if (c == '\n') {
                        statementUnderConstruction.append(' ');
                        break;
                    }
                    statementUnderConstruction.append(c);
                    if (c == '\"') {
                        this.state = LexState.INQUOTESTRING;
                        break;
                    }
                    if (c == '\'') {
                        this.state = LexState.INSQUOTESTRING;
                        break;
                    }
                    if (c != ';') break;
                    statements.add(statementUnderConstruction.toString().trim());
                    statementUnderConstruction.setLength(0);
                    break;
                }
                case INSINGLELINECOMMENT: {
                    if (c != '\n') break;
                    this.state = LexState.DEFAULT;
                    break;
                }
                case INMULTILINECOMMENT: {
                    if (c != '*' || this.peekAhead() != '/') continue block7;
                    this.state = LexState.DEFAULT;
                    this.advance();
                    break;
                }
                case INQUOTESTRING: {
                    statementUnderConstruction.append(c);
                    if (c != '\"') break;
                    if (this.peekAhead() == '\"') {
                        statementUnderConstruction.append(this.getChar());
                        break;
                    }
                    this.state = LexState.DEFAULT;
                    break;
                }
                case INSQUOTESTRING: {
                    statementUnderConstruction.append(c);
                    if (c != '\'') break;
                    if (this.peekAhead() == '\'') {
                        statementUnderConstruction.append(this.getChar());
                        break;
                    }
                    this.state = LexState.DEFAULT;
                }
            }
        }
        String tmp = statementUnderConstruction.toString().trim();
        if (tmp.length() > 0) {
            statements.add(tmp);
        }
        return statements;
    }

    static enum LexState {
        DEFAULT,
        INSINGLELINECOMMENT,
        INMULTILINECOMMENT,
        INQUOTESTRING,
        INSQUOTESTRING;

    }
}

