/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho.dataset.cql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.stream.Collectors;
import net.nmoncho.dataset.CQLDataSet;
import net.nmoncho.dataset.ParseException;
import net.nmoncho.dataset.cql.SimpleCQLLexer;

public abstract class AbstractCQLDataSet
implements CQLDataSet {
    public static final String END_OF_STATEMENT_DELIMITER = ";";
    private String dataSetLocation = null;
    private String keyspaceName = null;
    private boolean keyspaceCreation = true;
    private boolean keyspaceDeletion = true;

    public AbstractCQLDataSet(String dataSetLocation) {
        this.dataSetLocation = dataSetLocation;
    }

    public AbstractCQLDataSet(String dataSetLocation, boolean keyspaceCreation, boolean keyspaceDeletion) {
        this(dataSetLocation, keyspaceCreation, keyspaceDeletion, null);
    }

    public AbstractCQLDataSet(String dataSetLocation, String keyspaceName) {
        this(dataSetLocation, true, true, keyspaceName);
    }

    public AbstractCQLDataSet(String dataSetLocation, boolean keyspaceCreation, boolean keyspaceDeletion, String keyspaceName) {
        if (this.getInputDataSetLocation(dataSetLocation) == null) {
            throw new ParseException("Dataset not found");
        }
        this.dataSetLocation = dataSetLocation;
        this.keyspaceCreation = keyspaceCreation;
        this.keyspaceDeletion = keyspaceDeletion;
        if (keyspaceName != null) {
            this.keyspaceName = keyspaceName.toLowerCase();
        }
    }

    protected abstract InputStream getInputDataSetLocation(String var1);

    @Override
    public List<String> getCQLStatements() {
        return this.linesToCQLStatements(this.getLines());
    }

    private List<String> linesToCQLStatements(List<String> lines) {
        SimpleCQLLexer lexer = new SimpleCQLLexer(lines);
        return lexer.getStatements();
    }

    public List<String> getLines() {
        InputStream inputStream = this.getInputDataSetLocation(this.dataSetLocation);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));){
                return buffer.lines().collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public boolean isKeyspaceCreation() {
        return this.keyspaceCreation;
    }

    @Override
    public boolean isKeyspaceDeletion() {
        return this.keyspaceDeletion;
    }
}

