/*
 * Decompiled with CFR 0.152.
 */
package net.nmoncho;

import com.datastax.oss.driver.api.core.CqlSession;
import net.nmoncho.CQLDataLoader;
import net.nmoncho.CassandraCQLUnit;
import net.nmoncho.dataset.CQLDataSet;
import net.nmoncho.utils.EmbeddedCassandraServerHelper;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraUnit4CQLTestCase {
    private static final Logger log = LoggerFactory.getLogger(CQLDataLoader.class);
    private CassandraCQLUnit cassandraUnit;
    private boolean initialized = false;
    private CqlSession session;

    public AbstractCassandraUnit4CQLTestCase() {
        this.cassandraUnit = new CassandraCQLUnit(this.getDataSet());
    }

    public AbstractCassandraUnit4CQLTestCase(String configurationFileName) {
        this.cassandraUnit = new CassandraCQLUnit(this.getDataSet(), configurationFileName);
    }

    @Before
    public void before() throws Exception {
        if (!this.initialized) {
            this.cassandraUnit.before();
            this.session = this.cassandraUnit.session;
            this.initialized = true;
        }
    }

    @After
    public void after() {
        EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
    }

    public abstract CQLDataSet getDataSet();

    public CqlSession getSession() {
        return this.session;
    }
}

