/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.ArrayListMultimap;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStat;
import org.apache.cassandra.tools.nodetool.SetHostStat;

@Command(name="status", description="Print cluster information (state, load, IDs, ...)")
public class Status
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<keyspace>]", description="The keyspace name")
    private String keyspace = null;
    @Option(title="resolve_ip", name={"-r", "--resolve-ip"}, description="Show node domain names instead of IPs")
    private boolean resolveIp = false;
    private boolean isTokenPerNode = true;
    private String format = null;
    private Collection<String> joiningNodes;
    private Collection<String> leavingNodes;
    private Collection<String> movingNodes;
    private Collection<String> liveNodes;
    private Collection<String> unreachableNodes;
    private Map<String, String> loadMap;
    private Map<String, String> hostIDMap;
    private EndpointSnitchInfoMBean epSnitchInfo;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        this.joiningNodes = probe.getJoiningNodes();
        this.leavingNodes = probe.getLeavingNodes();
        this.movingNodes = probe.getMovingNodes();
        this.loadMap = probe.getLoadMap();
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap();
        this.liveNodes = probe.getLiveNodes();
        this.unreachableNodes = probe.getUnreachableNodes();
        this.hostIDMap = probe.getHostIdMap();
        this.epSnitchInfo = probe.getEndpointSnitchInfoProxy();
        StringBuilder errors = new StringBuilder();
        Map<InetAddress, Float> ownerships = null;
        boolean hasEffectiveOwns = false;
        try {
            ownerships = probe.effectiveOwnership(this.keyspace);
            hasEffectiveOwns = true;
        }
        catch (IllegalStateException e) {
            ownerships = probe.getOwnership();
            errors.append("Note: ").append(e.getMessage()).append("%n");
        }
        catch (IllegalArgumentException ex) {
            out.printf("%nError: %s%n", ex.getMessage());
            System.exit(1);
        }
        SortedMap<String, SetHostStat> dcs = NodeTool.getOwnershipByDc(probe, this.resolveIp, tokensToEndpoints, ownerships);
        if (dcs.values().size() < tokensToEndpoints.keySet().size()) {
            this.isTokenPerNode = false;
        }
        int maxAddressLength = this.computeMaxAddressLength(dcs);
        for (Map.Entry<String, SetHostStat> dc : dcs.entrySet()) {
            String dcHeader = String.format("Datacenter: %s%n", dc.getKey());
            out.print(dcHeader);
            for (int i = 0; i < dcHeader.length() - 1; ++i) {
                out.print('=');
            }
            out.println();
            out.println("Status=Up/Down");
            out.println("|/ State=Normal/Leaving/Joining/Moving");
            this.printNodesHeader(hasEffectiveOwns, this.isTokenPerNode, maxAddressLength, out);
            ArrayListMultimap hostToTokens = ArrayListMultimap.create();
            for (HostStat stat : dc.getValue()) {
                hostToTokens.put((Object)stat.endpoint, (Object)stat);
            }
            for (InetAddress endpoint : hostToTokens.keySet()) {
                Float owns = ownerships.get(endpoint);
                List tokens = hostToTokens.get((Object)endpoint);
                this.printNode(endpoint.getHostAddress(), owns, tokens, hasEffectiveOwns, this.isTokenPerNode, maxAddressLength, out);
            }
        }
        out.printf("%n" + errors, new Object[0]);
    }

    private int computeMaxAddressLength(Map<String, SetHostStat> dcs) {
        int maxAddressLength = 0;
        HashSet<InetAddress> seenHosts = new HashSet<InetAddress>();
        for (SetHostStat stats : dcs.values()) {
            for (HostStat stat : stats) {
                if (!seenHosts.add(stat.endpoint)) continue;
                maxAddressLength = Math.max(maxAddressLength, stat.ipOrDns().length());
            }
        }
        return maxAddressLength;
    }

    private void printNodesHeader(boolean hasEffectiveOwns, boolean isTokenPerNode, int maxAddressLength, PrintStream out) {
        String owns;
        String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode, maxAddressLength);
        String string = owns = hasEffectiveOwns ? "Owns (effective)" : "Owns";
        if (isTokenPerNode) {
            out.printf(fmt, "-", "-", "Address", "Load", owns, "Host ID", "Token", "Rack");
        } else {
            out.printf(fmt, "-", "-", "Address", "Load", "Tokens", owns, "Host ID", "Rack");
        }
    }

    private void printNode(String endpoint, Float owns, List<HostStat> tokens, boolean hasEffectiveOwns, boolean isTokenPerNode, int maxAddressLength, PrintStream out) {
        String rack;
        String fmt = this.getFormat(hasEffectiveOwns, isTokenPerNode, maxAddressLength);
        String status = this.liveNodes.contains(endpoint) ? "U" : (this.unreachableNodes.contains(endpoint) ? "D" : "?");
        String state = this.joiningNodes.contains(endpoint) ? "J" : (this.leavingNodes.contains(endpoint) ? "L" : (this.movingNodes.contains(endpoint) ? "M" : "N"));
        String load = this.loadMap.containsKey(endpoint) ? this.loadMap.get(endpoint) : "?";
        String strOwns = owns != null && hasEffectiveOwns ? new DecimalFormat("##0.0%").format(owns) : "?";
        String hostID = this.hostIDMap.get(endpoint);
        try {
            rack = this.epSnitchInfo.getRack(endpoint);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String endpointDns = tokens.get(0).ipOrDns();
        if (isTokenPerNode) {
            out.printf(fmt, status, state, endpointDns, load, strOwns, hostID, tokens.get((int)0).token, rack);
        } else {
            out.printf(fmt, status, state, endpointDns, load, tokens.size(), strOwns, hostID, rack);
        }
    }

    private String getFormat(boolean hasEffectiveOwns, boolean isTokenPerNode, int maxAddressLength) {
        if (this.format == null) {
            StringBuilder buf = new StringBuilder();
            String addressPlaceholder = String.format("%%-%ds  ", maxAddressLength);
            buf.append("%s%s  ");
            buf.append(addressPlaceholder);
            buf.append("%-9s  ");
            if (!isTokenPerNode) {
                buf.append("%-11s  ");
            }
            if (hasEffectiveOwns) {
                buf.append("%-16s  ");
            } else {
                buf.append("%-6s  ");
            }
            buf.append("%-36s  ");
            if (isTokenPerNode) {
                buf.append("%-39s  ");
            }
            buf.append("%s%n");
            this.format = buf.toString();
        }
        return this.format;
    }
}

