/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public abstract class Splitter {
    private final IPartitioner partitioner;

    protected Splitter(IPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    protected abstract Token tokenForValue(BigInteger var1);

    protected abstract BigInteger valueForToken(Token var1);

    public List<Token> splitOwnedRanges(int parts, List<Range<Token>> localRanges, boolean dontSplitRanges) {
        if (localRanges.isEmpty() || parts == 1) {
            return Collections.singletonList(this.partitioner.getMaximumToken());
        }
        BigInteger totalTokens = BigInteger.ZERO;
        for (Range<Token> r : localRanges) {
            BigInteger right = this.valueForToken(this.token((Token)r.right));
            totalTokens = totalTokens.add(right.subtract(this.valueForToken((Token)r.left)));
        }
        BigInteger perPart = totalTokens.divide(BigInteger.valueOf(parts));
        if (perPart.equals(BigInteger.ZERO)) {
            return Collections.singletonList(this.partitioner.getMaximumToken());
        }
        if (dontSplitRanges) {
            return this.splitOwnedRangesNoPartialRanges(localRanges, perPart, parts);
        }
        ArrayList<Token> boundaries = new ArrayList<Token>();
        BigInteger sum = BigInteger.ZERO;
        BigInteger tokensLeft = totalTokens;
        for (Range<Token> r : localRanges) {
            Token right = this.token((Token)r.right);
            BigInteger currentRangeWidth = this.valueForToken(right).subtract(this.valueForToken((Token)r.left)).abs();
            BigInteger left = this.valueForToken((Token)r.left);
            while (sum.add(currentRangeWidth).compareTo(perPart) >= 0) {
                BigInteger withinRangeBoundary = perPart.subtract(sum);
                left = left.add(withinRangeBoundary);
                boundaries.add(this.tokenForValue(left));
                tokensLeft = tokensLeft.subtract(perPart);
                currentRangeWidth = currentRangeWidth.subtract(withinRangeBoundary);
                sum = BigInteger.ZERO;
                int partsLeft = parts - boundaries.size();
                if (partsLeft == 0) break;
                if (partsLeft != 1) continue;
                perPart = tokensLeft;
            }
            sum = sum.add(currentRangeWidth);
        }
        boundaries.set(boundaries.size() - 1, this.partitioner.getMaximumToken());
        assert (boundaries.size() == parts) : boundaries.size() + "!=" + parts + " " + boundaries + ":" + localRanges;
        return boundaries;
    }

    private List<Token> splitOwnedRangesNoPartialRanges(List<Range<Token>> localRanges, BigInteger perPart, int parts) {
        ArrayList<Token> boundaries = new ArrayList<Token>(parts);
        BigInteger sum = BigInteger.ZERO;
        int rangesCount = localRanges.size();
        for (int i = 0; boundaries.size() < parts - 1 && i < rangesCount - 1; ++i) {
            Range<Token> r = localRanges.get(i);
            Range<Token> nextRange = localRanges.get(i + 1);
            Token right = this.token((Token)r.right);
            Token nextRight = this.token((Token)nextRange.right);
            BigInteger currentRangeWidth = this.valueForToken(right).subtract(this.valueForToken((Token)r.left));
            BigInteger nextRangeWidth = this.valueForToken(nextRight).subtract(this.valueForToken((Token)nextRange.left));
            if ((sum = sum.add(currentRangeWidth)).compareTo(perPart) <= 0 && sum.add(nextRangeWidth).compareTo(perPart) <= 0) continue;
            BigInteger diffCurrent = sum.subtract(perPart).abs();
            BigInteger diffNext = sum.add(nextRangeWidth).subtract(perPart).abs();
            if (diffNext.compareTo(diffCurrent) < 0) continue;
            sum = BigInteger.ZERO;
            boundaries.add(right);
        }
        boundaries.add(this.partitioner.getMaximumToken());
        return boundaries;
    }

    private Token token(Token t) {
        return t.equals(this.partitioner.getMinimumToken()) ? this.partitioner.getMaximumToken() : t;
    }
}

