/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class SchemaAlteringStatement
extends CFStatement
implements CQLStatement {
    private final boolean isColumnFamilyLevel;

    protected SchemaAlteringStatement() {
        super(null);
        this.isColumnFamilyLevel = false;
    }

    protected SchemaAlteringStatement(CFName name) {
        super(name);
        this.isColumnFamilyLevel = true;
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            super.prepareKeyspace(state);
        }
    }

    @Override
    public ParsedStatement.Prepared prepare(ClientState clientState) {
        if (this.isColumnFamilyLevel && clientState.isNoCompactMode()) {
            CFMetaData baseTable;
            CFMetaData table = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
            if (table.isCompactTable()) {
                throw RequestValidations.invalidRequest("Cannot alter schema of compact table %s.%s from a connection in NO-COMPACT mode", table.ksName, table.cfName);
            }
            if (table.isView() && (baseTable = Schema.instance.getView(table.ksName, table.cfName).baseTableMetadata()).isCompactTable()) {
                throw new InvalidRequestException(String.format("Cannot ALTER schema of view %s.%s on compact table %s from a connection in NO-COMPACT mode", table.ksName, table.cfName, baseTable.ksName, baseTable.cfName));
            }
        }
        return new ParsedStatement.Prepared(this);
    }

    protected void grantPermissionsToCreator(QueryState state) {
    }

    protected abstract Event.SchemaChange announceMigration(QueryState var1, boolean var2) throws RequestValidationException;

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options, long queryStartNanoTime) throws RequestValidationException {
        Event.SchemaChange ce = this.announceMigration(state, false);
        if (ce == null) {
            return new ResultMessage.Void();
        }
        AuthenticatedUser user = state.getClientState().getUser();
        if (user != null && !user.isAnonymous() && ce.change == Event.SchemaChange.Change.CREATED) {
            try {
                this.grantPermissionsToCreator(state);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return new ResultMessage.SchemaChange(ce);
    }

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        Event.SchemaChange ce = this.announceMigration(state, true);
        return ce == null ? new ResultMessage.Void() : new ResultMessage.SchemaChange(ce);
    }
}

