/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.nmoncho.shaded.com.google.common.util.concurrent.FutureCallback;
import net.nmoncho.shaded.io.netty.util.concurrent.Future;
import net.nmoncho.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.cassandra.utils.concurrent.AbstractFuture;
import org.apache.cassandra.utils.concurrent.Promise;
import org.apache.cassandra.utils.concurrent.SyncFuture;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public class SyncPromise<V>
extends SyncFuture<V>
implements Promise<V> {
    public SyncPromise() {
    }

    SyncPromise(AbstractFuture.FailureHolder initialState) {
        super(initialState);
    }

    public SyncPromise(GenericFutureListener<? extends Future<? super V>> listener) {
        super(listener);
    }

    SyncPromise(AbstractFuture.FailureHolder initialState, GenericFutureListener<? extends Future<? super V>> listener) {
        super(initialState, listener);
    }

    public static <V> SyncPromise<V> withExecutor(Executor executor) {
        return new WithExecutor(executor);
    }

    public static <V> SyncPromise<V> uncancellable() {
        return new SyncPromise<V>(UNCANCELLABLE);
    }

    public static <V> SyncPromise<V> uncancellable(Executor executor) {
        return new WithExecutor(executor, UNCANCELLABLE);
    }

    public static <V> SyncPromise<V> uncancellable(GenericFutureListener<? extends Future<? super V>> listener) {
        return new SyncPromise<V>(UNCANCELLABLE, listener);
    }

    @Override
    public Promise<V> setSuccess(V v) {
        if (!this.trySuccess(v)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public boolean trySuccess(V v) {
        return super.trySuccess(v);
    }

    @Override
    public Promise<V> setFailure(Throwable throwable) {
        if (!this.tryFailure(throwable)) {
            throw new IllegalStateException("complete already: " + this);
        }
        return this;
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return super.tryFailure(throwable);
    }

    @Override
    public boolean setUncancellable() {
        return super.setUncancellable();
    }

    @Override
    public boolean setUncancellableExclusive() {
        return super.setUncancellableExclusive();
    }

    @Override
    public boolean isUncancellable() {
        return super.isUncancellable();
    }

    @Override
    public Promise<V> sync() throws InterruptedException {
        super.sync();
        return this;
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public SyncPromise<V> addListener(GenericFutureListener<? extends Future<? super V>> listener) {
        super.addListener((GenericFutureListener)listener);
        return this;
    }

    @Override
    public SyncPromise<V> addListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        super.addListeners((GenericFutureListener[])listeners);
        return this;
    }

    @Override
    public SyncPromise<V> removeListener(GenericFutureListener<? extends Future<? super V>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SyncPromise<V> removeListeners(GenericFutureListener<? extends Future<? super V>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SyncPromise<V> addCallback(FutureCallback<? super V> callback) {
        super.addCallback((FutureCallback)callback);
        return this;
    }

    @Override
    public SyncPromise<V> addCallback(FutureCallback<? super V> callback, Executor executor) {
        super.addCallback((FutureCallback)callback, executor);
        return this;
    }

    @Override
    public SyncPromise<V> addCallback(Consumer<? super V> onSuccess, Consumer<? super Throwable> onFailure) {
        super.addCallback((Consumer)onSuccess, (Consumer)onFailure);
        return this;
    }

    @Override
    public SyncPromise<V> await() throws InterruptedException {
        super.await();
        return this;
    }

    @Override
    public SyncPromise<V> awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public SyncPromise<V> awaitThrowUncheckedOnInterrupt() throws UncheckedInterruptedException {
        super.awaitThrowUncheckedOnInterrupt();
        return this;
    }

    public static class WithExecutor<V>
    extends SyncPromise<V> {
        final Executor notifyExecutor;

        protected WithExecutor(Executor notifyExecutor) {
            this.notifyExecutor = notifyExecutor;
        }

        protected WithExecutor(Executor notifyExecutor, AbstractFuture.FailureHolder initialState) {
            super(initialState);
            this.notifyExecutor = notifyExecutor;
        }

        protected WithExecutor(Executor notifyExecutor, GenericFutureListener<? extends Future<? super V>> listener) {
            super(listener);
            this.notifyExecutor = notifyExecutor;
        }

        @Override
        public Executor notifyExecutor() {
            return this.notifyExecutor;
        }
    }
}

