/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.io.netty.util.concurrent.Promise;
import org.apache.cassandra.utils.concurrent.AsyncPromise;
import org.apache.cassandra.utils.concurrent.Future;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

public class LoadingMap<K, V> {
    private final NonBlockingHashMap<K, Future<V>> internalMap = new NonBlockingHashMap();

    @VisibleForTesting
    Future<V> get(K key) {
        return (Future)this.internalMap.get(key);
    }

    public V getIfReady(K key) {
        Future future = (Future)this.internalMap.get(key);
        return (V)(future != null ? future.getNow() : null);
    }

    public V blockingLoadIfAbsent(K key, Supplier<? extends V> loadFunction) throws RuntimeException {
        while (true) {
            Object v;
            AsyncPromise newEntry;
            AsyncPromise future = (AsyncPromise)this.internalMap.get(key);
            boolean attemptedInThisThread = false;
            if (future == null && (future = (Future)this.internalMap.putIfAbsent(key, newEntry = new AsyncPromise())) == null) {
                attemptedInThisThread = true;
                future = newEntry;
                try {
                    V v2 = loadFunction.get();
                    if (v2 == null) {
                        throw new NullPointerException("The mapping function returned null");
                    }
                    newEntry.setSuccess((Object)v2);
                }
                catch (Throwable t) {
                    newEntry.setFailure(t);
                    this.internalMap.remove(key, future);
                }
            }
            if ((v = future.awaitUninterruptibly().getNow()) != null) {
                return (V)v;
            }
            if (attemptedInThisThread) {
                future.rethrowIfFailed();
            }
            Thread.yield();
        }
    }

    public V blockingUnloadIfPresent(K key, Consumer<? super V> unloadFunction) throws UnloadExecutionException {
        Future existingFuture;
        Promise droppedFuture = new AsyncPromise().setSuccess((Object)null);
        do {
            if ((existingFuture = (Future)this.internalMap.get(key)) != null && (!existingFuture.isDone() || existingFuture.getNow() != null)) continue;
            return null;
        } while (!this.internalMap.replace(key, (Object)existingFuture, (Object)droppedFuture));
        Object v = existingFuture.awaitUninterruptibly().getNow();
        try {
            if (v == null) {
                V v2 = null;
                return v2;
            }
            unloadFunction.accept(v);
            Object object = v;
            return (V)object;
        }
        catch (Throwable t) {
            throw new UnloadExecutionException(v, t);
        }
        finally {
            Future future = (Future)this.internalMap.remove(key);
            assert (future == droppedFuture);
        }
    }

    public static class UnloadExecutionException
    extends ExecutionException {
        private final Object value;

        public UnloadExecutionException(Object value, Throwable cause) {
            super(cause);
            this.value = value;
        }

        public <T> T value() {
            return (T)this.value;
        }
    }
}

