/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.nmoncho.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.apache.cassandra.utils.concurrent.AbstractFuture;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ListenerList;
import org.apache.cassandra.utils.concurrent.WaitQueue;

public class AsyncFuture<V>
extends AbstractFuture<V> {
    private static final AtomicReferenceFieldUpdater<AsyncFuture, WaitQueue> waitingUpdater = AtomicReferenceFieldUpdater.newUpdater(AsyncFuture.class, WaitQueue.class, "waiting");
    private volatile WaitQueue waiting;

    public AsyncFuture() {
    }

    protected AsyncFuture(V immediateSuccess) {
        super(immediateSuccess);
    }

    protected AsyncFuture(Throwable immediateFailure) {
        super(immediateFailure);
    }

    protected AsyncFuture(AbstractFuture.FailureHolder initialState) {
        super(initialState);
    }

    protected AsyncFuture(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        super(listener);
    }

    protected AsyncFuture(AbstractFuture.FailureHolder initialState, GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        super(initialState, listener);
    }

    @Override
    boolean trySet(Object v) {
        Object current;
        do {
            if (!AsyncFuture.isDone(current = this.result) && (current != UNCANCELLABLE || v != CANCELLED && v != UNCANCELLABLE)) continue;
            return false;
        } while (!resultUpdater.compareAndSet(this, current, v));
        if (v != UNCANCELLABLE) {
            ListenerList.notify(listenersUpdater, this);
            Awaitable.AsyncAwaitable.signalAll(waitingUpdater, this);
        }
        return true;
    }

    @Override
    void appendListener(ListenerList<V> newListener) {
        ListenerList.push(listenersUpdater, this, newListener);
        if (this.isDone()) {
            ListenerList.notify(listenersUpdater, this);
        }
    }

    @Override
    public <T> Future<T> map(Function<? super V, ? extends T> mapper, Executor executor) {
        return this.map(new AsyncFuture<V>(), mapper, executor);
    }

    @Override
    public <T> Future<T> flatMap(Function<? super V, ? extends Future<T>> flatMapper, @Nullable Executor executor) {
        return this.flatMap(new AsyncFuture<V>(), flatMapper, executor);
    }

    @Override
    public AsyncFuture<V> await() throws InterruptedException {
        return Awaitable.AsyncAwaitable.await(waitingUpdater, java.util.concurrent.Future::isDone, this);
    }

    @Override
    public boolean awaitUntil(long nanoTimeDeadline) throws InterruptedException {
        return Awaitable.AsyncAwaitable.awaitUntil(waitingUpdater, java.util.concurrent.Future::isDone, this, nanoTimeDeadline);
    }
}

