/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.util.concurrent.FutureCallback;
import net.nmoncho.shaded.io.netty.util.concurrent.GenericFutureListener;
import net.nmoncho.shaded.io.netty.util.internal.ThrowableUtil;
import org.apache.cassandra.utils.concurrent.Awaitable;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.ListenerList;
import org.apache.cassandra.utils.concurrent.UncheckedInterruptedException;

public abstract class AbstractFuture<V>
implements Future<V> {
    protected static final FailureHolder UNSET = new FailureHolder(null);
    protected static final FailureHolder UNCANCELLABLE = new FailureHolder(null);
    protected static final FailureHolder CANCELLED = new FailureHolder(ThrowableUtil.unknownStackTrace((Throwable)new CancellationException(), AbstractFuture.class, (String)"cancel(...)"));
    volatile Object result;
    volatile ListenerList<V> listeners;
    static final AtomicReferenceFieldUpdater<AbstractFuture, Object> resultUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "result");
    static final AtomicReferenceFieldUpdater<AbstractFuture, ListenerList> listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, ListenerList.class, "listeners");

    private static Throwable cause(Object result) {
        return result instanceof FailureHolder ? ((FailureHolder)result).cause : null;
    }

    static boolean isSuccess(Object result) {
        return !(result instanceof FailureHolder);
    }

    static boolean isCancelled(Object result) {
        return result == CANCELLED;
    }

    static boolean isDone(Object result) {
        return result != UNSET && result != UNCANCELLABLE;
    }

    protected AbstractFuture(FailureHolder initialState) {
        resultUpdater.lazySet(this, initialState);
    }

    public AbstractFuture() {
        this(UNSET);
    }

    protected AbstractFuture(V immediateSuccess) {
        resultUpdater.lazySet(this, immediateSuccess);
    }

    protected AbstractFuture(Throwable immediateFailure) {
        this(new FailureHolder(immediateFailure));
    }

    protected AbstractFuture(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        this();
        listenersUpdater.lazySet(this, new ListenerList.GenericFutureListenerList(listener));
    }

    protected AbstractFuture(FailureHolder initialState, GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        this(initialState);
        listenersUpdater.lazySet(this, new ListenerList.GenericFutureListenerList(listener));
    }

    @Override
    public Executor notifyExecutor() {
        return null;
    }

    protected boolean trySuccess(V v) {
        return this.trySet(v);
    }

    protected boolean tryFailure(Throwable throwable) {
        return this.trySet(new FailureHolder(throwable));
    }

    protected boolean setUncancellable() {
        if (this.trySet(UNCANCELLABLE)) {
            return true;
        }
        return this.isUncancellable();
    }

    protected boolean setUncancellableExclusive() {
        return this.trySet(UNCANCELLABLE);
    }

    protected boolean isUncancellable() {
        Object result = this.result;
        return result == UNCANCELLABLE || AbstractFuture.isDone(result) && !AbstractFuture.isCancelled(result);
    }

    @Override
    public boolean cancel(boolean b) {
        return this.trySet(CANCELLED);
    }

    abstract boolean trySet(Object var1);

    public boolean isSuccess() {
        return AbstractFuture.isSuccess(this.result);
    }

    @Override
    public boolean isCancelled() {
        return AbstractFuture.isCancelled(this.result);
    }

    @Override
    public boolean isDone() {
        return AbstractFuture.isDone(this.result);
    }

    public boolean isCancellable() {
        return this.result == UNSET;
    }

    public Throwable cause() {
        return AbstractFuture.cause(this.result);
    }

    public V getNow() {
        Object result = this.result;
        if (AbstractFuture.isSuccess(result)) {
            return (V)result;
        }
        return null;
    }

    protected V getWhenDone() throws ExecutionException {
        Object result = this.result;
        if (AbstractFuture.isSuccess(result)) {
            return (V)result;
        }
        if (result == CANCELLED) {
            throw new CancellationException();
        }
        throw new ExecutionException(((FailureHolder)result).cause);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.await();
        return this.getWhenDone();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getWhenDone();
    }

    abstract void appendListener(ListenerList<V> var1);

    @Override
    public AbstractFuture<V> addCallback(FutureCallback<? super V> callback) {
        this.appendListener(new ListenerList.CallbackListener<V>(this, callback));
        return this;
    }

    @Override
    public AbstractFuture<V> addCallback(BiConsumer<? super V, Throwable> callback) {
        this.appendListener(new ListenerList.CallbackBiConsumerListener<V>(this, callback, null));
        return this;
    }

    @Override
    public Future<V> addCallback(BiConsumer<? super V, Throwable> callback, Executor executor) {
        this.appendListener(new ListenerList.CallbackBiConsumerListener<V>(this, callback, executor));
        return this;
    }

    @Override
    public AbstractFuture<V> addCallback(FutureCallback<? super V> callback, Executor executor) {
        Preconditions.checkNotNull(executor);
        this.appendListener(new ListenerList.CallbackListenerWithExecutor<V>(this, callback, executor));
        return this;
    }

    @Override
    public AbstractFuture<V> addCallback(Consumer<? super V> onSuccess, Consumer<? super Throwable> onFailure) {
        this.appendListener(new ListenerList.CallbackLambdaListener<V>(this, onSuccess, onFailure, null));
        return this;
    }

    @Override
    public <T> Future<T> map(Function<? super V, ? extends T> mapper) {
        return this.map(mapper, null);
    }

    @Override
    public AbstractFuture<V> addCallback(Consumer<? super V> onSuccess, Consumer<? super Throwable> onFailure, Executor executor) {
        this.appendListener(new ListenerList.CallbackLambdaListener<V>(this, onSuccess, onFailure, executor));
        return this;
    }

    protected <T> Future<T> map(AbstractFuture<T> result, Function<? super V, ? extends T> mapper, @Nullable Executor executor) {
        this.addListener(() -> {
            try {
                if (this.isSuccess()) {
                    result.trySet(mapper.apply((V)this.getNow()));
                } else {
                    result.tryFailure(this.cause());
                }
            }
            catch (Throwable t) {
                result.tryFailure(t);
                throw t;
            }
        }, executor);
        return result;
    }

    protected <T> Future<T> flatMap(AbstractFuture<T> result, Function<? super V, ? extends Future<T>> flatMapper, @Nullable Executor executor) {
        this.addListener(() -> {
            try {
                if (this.isSuccess()) {
                    ((Future)flatMapper.apply((V)this.getNow())).addListener((GenericFutureListener)AbstractFuture.propagate(result));
                } else {
                    result.tryFailure(this.cause());
                }
            }
            catch (Throwable t) {
                result.tryFailure(t);
                throw t;
            }
        }, executor);
        return result;
    }

    @Override
    public Future<V> addListener(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        this.appendListener(new ListenerList.GenericFutureListenerList(listener));
        return this;
    }

    @Override
    public void addListener(Runnable task, @Nullable Executor executor) {
        this.appendListener(new ListenerList.RunnableWithExecutor(task, executor));
    }

    @Override
    public void addListener(Runnable task) {
        this.appendListener(new ListenerList.RunnableWithNotifyExecutor(task));
    }

    @Override
    public Future<V> addListeners(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> ... listeners) {
        return this.addListener(future -> {
            for (GenericFutureListener listener : listeners) {
                ListenerList.notifyListener(listener, future);
            }
        });
    }

    @Override
    public Future<V> removeListener(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<V> removeListeners(GenericFutureListener<? extends net.nmoncho.shaded.io.netty.util.concurrent.Future<? super V>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return Awaitable.Defaults.await(this, timeout, unit);
    }

    @Override
    public boolean awaitThrowUncheckedOnInterrupt(long time, TimeUnit units) throws UncheckedInterruptedException {
        return Awaitable.Defaults.awaitThrowUncheckedOnInterrupt(this, time, units);
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return Awaitable.Defaults.awaitUninterruptibly(this, timeout, unit);
    }

    @Override
    public boolean awaitUntilThrowUncheckedOnInterrupt(long nanoTimeDeadline) throws UncheckedInterruptedException {
        return Awaitable.Defaults.awaitUntilThrowUncheckedOnInterrupt(this, nanoTimeDeadline);
    }

    @Override
    public boolean awaitUntilUninterruptibly(long nanoTimeDeadline) {
        return Awaitable.Defaults.awaitUntilUninterruptibly(this, nanoTimeDeadline);
    }

    @Override
    public Future<V> awaitUninterruptibly() {
        return Awaitable.Defaults.awaitUninterruptibly(this);
    }

    @Override
    public Future<V> awaitThrowUncheckedOnInterrupt() throws UncheckedInterruptedException {
        return Awaitable.Defaults.awaitThrowUncheckedOnInterrupt(this);
    }

    public String toString() {
        String description = this.description();
        String state = this.state();
        return description == null ? state : state + ' ' + description;
    }

    private String state() {
        Object result = this.result;
        if (AbstractFuture.isSuccess(result)) {
            return "(success: " + result + ')';
        }
        if (result == UNCANCELLABLE) {
            return "(uncancellable)";
        }
        if (result == CANCELLED) {
            return "(cancelled)";
        }
        if (AbstractFuture.isDone(result)) {
            return "(failure: " + ((FailureHolder)result).cause + ')';
        }
        return "(incomplete)";
    }

    protected String description() {
        return null;
    }

    private static <V> GenericFutureListener<? extends Future<V>> propagate(AbstractFuture<? super V> to) {
        return from -> {
            if (from.isSuccess()) {
                to.trySuccess(from.getNow());
            } else {
                to.tryFailure(from.cause());
            }
        };
    }

    static class FailureHolder {
        final Throwable cause;

        FailureHolder(Throwable cause) {
            this.cause = cause;
        }
    }
}

