/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.hash.Hasher;
import net.nmoncho.shaded.com.google.common.hash.Hashing;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.UUIDGen;

@Shared(inner=Shared.Recursive.INTERFACES)
public class TimeUUID
implements Serializable,
Comparable<TimeUUID> {
    public static final long serialVersionUID = 1L;
    public static final long UUID_EPOCH_UNIX_MILLIS = -12219292800000L;
    protected static final long TIMESTAMP_UUID_VERSION_IN_MSB = 4096L;
    protected static final long UUID_VERSION_BITS_IN_MSB = 61440L;
    public static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    final long uuidTimestamp;
    final long lsb;

    public TimeUUID(long uuidTimestamp, long lsb) {
        this.uuidTimestamp = uuidTimestamp;
        this.lsb = lsb;
    }

    public static TimeUUID atUnixMicrosWithLsb(long unixMicros, long uniqueLsb) {
        return new TimeUUID(TimeUUID.unixMicrosToRawTimestamp(unixMicros), uniqueLsb);
    }

    public static UUID atUnixMicrosWithLsbAsUUID(long unixMicros, long uniqueLsb) {
        return new UUID(TimeUUID.rawTimestampToMsb(TimeUUID.unixMicrosToRawTimestamp(unixMicros)), uniqueLsb);
    }

    public static TimeUUID minAtUnixMillis(long unixMillis) {
        return new TimeUUID(TimeUUID.unixMillisToRawTimestamp(unixMillis, 0L), -9187201950435737472L);
    }

    public static TimeUUID maxAtUnixMillis(long unixMillis) {
        return new TimeUUID(TimeUUID.unixMillisToRawTimestamp(unixMillis + 1L, 0L) - 1L, 0x7F7F7F7F7F7F7F7FL);
    }

    public static TimeUUID fromString(String uuidString) {
        return TimeUUID.fromUuid(UUID.fromString(uuidString));
    }

    public static TimeUUID fromUuid(UUID uuid) {
        return TimeUUID.fromBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static TimeUUID fromBytes(long msb, long lsb) {
        return new TimeUUID(TimeUUID.msbToRawTimestamp(msb), lsb);
    }

    public static TimeUUID deserialize(ByteBuffer buffer) {
        return TimeUUID.fromBytes(buffer.getLong(buffer.position()), buffer.getLong(buffer.position() + 8));
    }

    public static TimeUUID deserialize(DataInput in) throws IOException {
        long msb = in.readLong();
        long lsb = in.readLong();
        return TimeUUID.fromBytes(msb, lsb);
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeLong(this.msb());
        out.writeLong(this.lsb());
    }

    public ByteBuffer toBytes() {
        return ByteBuffer.wrap(TimeUUID.toBytes(this.msb(), this.lsb()));
    }

    public static byte[] toBytes(long msb, long lsb) {
        int i;
        byte[] uuidBytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            uuidBytes[i] = (byte)(lsb >>> 8 * (15 - i));
        }
        return uuidBytes;
    }

    public static long sizeInBytes() {
        return 16L;
    }

    public UUID asUUID() {
        return new UUID(TimeUUID.rawTimestampToMsb(this.uuidTimestamp), this.lsb);
    }

    public long unix(TimeUnit units) {
        return units.convert(this.unixMicros(), TimeUnit.MICROSECONDS);
    }

    public long unixMicros() {
        return TimeUUID.rawTimestampToUnixMicros(this.uuidTimestamp);
    }

    public long uuidTimestamp() {
        return this.uuidTimestamp & 0xFFFFFFFFFFFFFFFL;
    }

    public long msb() {
        return TimeUUID.rawTimestampToMsb(this.uuidTimestamp);
    }

    public long lsb() {
        return this.lsb;
    }

    public static long rawTimestampToUnixMicros(long rawTimestamp) {
        return rawTimestamp / 10L + -12219292800000000L;
    }

    public static long unixMillisToRawTimestamp(long unixMillis, long tenthsOfAMicro) {
        return unixMillis * 10000L - -122192928000000000L + tenthsOfAMicro;
    }

    public static long unixMicrosToRawTimestamp(long unixMicros) {
        return unixMicros * 10L - -122192928000000000L;
    }

    public static long msbToRawTimestamp(long msb) {
        assert ((0xF000L & msb) == 4096L);
        return ((msb &= 0xFFFFFFFFFFFFEFFFL) & 0xFFFFL) << 48 | (msb & 0xFFFF0000L) << 16 | msb >>> 32;
    }

    public static long rawTimestampToMsb(long rawTimestamp) {
        return 0x1000L | rawTimestamp >>> 48 | (rawTimestamp & 0xFFFF00000000L) >>> 16 | rawTimestamp << 32;
    }

    public int hashCode() {
        return (int)((this.uuidTimestamp ^ (this.uuidTimestamp >> 32) * 31L) + (this.lsb ^ this.lsb >> 32));
    }

    public boolean equals(Object that) {
        return that instanceof UUID && this.equals((UUID)that) || that instanceof TimeUUID && this.equals((TimeUUID)that);
    }

    public boolean equals(TimeUUID that) {
        return that != null && this.uuidTimestamp == that.uuidTimestamp && this.lsb == that.lsb;
    }

    public boolean equals(UUID that) {
        return that != null && this.uuidTimestamp == that.timestamp() && this.lsb == that.getLeastSignificantBits();
    }

    public String toString() {
        return this.asUUID().toString();
    }

    public static String toString(TimeUUID ballot) {
        return ballot == null ? "null" : ballot.uuidTimestamp() + ":" + ballot;
    }

    public static String toString(TimeUUID ballot, String kind) {
        return ballot == null ? "null" : String.format("%s(%d:%s)", kind, ballot.uuidTimestamp(), ballot);
    }

    @Override
    public int compareTo(TimeUUID that) {
        return this.uuidTimestamp != that.uuidTimestamp ? Long.compare(this.uuidTimestamp, that.uuidTimestamp) : Long.compare(this.lsb, that.lsb);
    }

    public static class Generator {
        private static final long clockSeqAndNode = Generator.makeClockSeqAndNode();
        private static final AtomicLong lastMicros = new AtomicLong();

        public static TimeUUID nextTimeUUID() {
            return TimeUUID.atUnixMicrosWithLsb(Generator.nextUnixMicros(), clockSeqAndNode);
        }

        public static UUID nextTimeAsUUID() {
            return TimeUUID.atUnixMicrosWithLsbAsUUID(Generator.nextUnixMicros(), clockSeqAndNode);
        }

        public static TimeUUID atUnixMillis(long unixMillis) {
            return Generator.atUnixMillis(unixMillis, 0L);
        }

        public static TimeUUID atUnixMillis(long unixMillis, long tenthsOfAMicro) {
            return new TimeUUID(TimeUUID.unixMillisToRawTimestamp(unixMillis, tenthsOfAMicro), clockSeqAndNode);
        }

        public static byte[] atUnixMillisAsBytes(long unixMillis) {
            return Generator.atUnixMillisAsBytes(unixMillis, 0L);
        }

        public static byte[] atUnixMillisAsBytes(long unixMillis, long tenthsOfAMicro) {
            return TimeUUID.toBytes(TimeUUID.rawTimestampToMsb(TimeUUID.unixMillisToRawTimestamp(unixMillis, tenthsOfAMicro)), clockSeqAndNode);
        }

        public static byte[] nextTimeUUIDAsBytes() {
            return TimeUUID.toBytes(TimeUUID.rawTimestampToMsb(TimeUUID.unixMicrosToRawTimestamp(Generator.nextUnixMicros())), clockSeqAndNode);
        }

        private static long nextUnixMicros() {
            long newLastMicros;
            block1: {
                long originalLastNanos;
                while ((newLastMicros = Clock.Global.currentTimeMillis() * 1000L) > (originalLastNanos = lastMicros.get())) {
                    if (!lastMicros.compareAndSet(originalLastNanos, newLastMicros)) continue;
                    break block1;
                }
                newLastMicros = lastMicros.incrementAndGet();
            }
            return newLastMicros;
        }

        private static long makeClockSeqAndNode() {
            if (CassandraRelevantProperties.DETERMINISM_UNSAFE_UUID_NODE.getBoolean()) {
                return FBUtilities.getBroadcastAddressAndPort().addressBytes[3];
            }
            Long specified = Long.getLong("cassandra.unsafe.timeuuidnode");
            if (specified != null) {
                return specified ^ (long)FBUtilities.getBroadcastAddressAndPort().addressBytes[3] ^ (long)(FBUtilities.getBroadcastAddressAndPort().addressBytes[2] << 8);
            }
            long clock = new SecureRandom().nextLong();
            long lsb = 0L;
            lsb |= Long.MIN_VALUE;
            lsb |= (clock & 0x3FFFL) << 48;
            return lsb |= Generator.makeNode();
        }

        private static long makeNode() {
            Collection<InetAddressAndPort> localAddresses = Generator.getAllLocalAddresses();
            if (localAddresses.isEmpty()) {
                throw new RuntimeException("Cannot generate the node component of the UUID because cannot retrieve any IP addresses.");
            }
            byte[] hash = Generator.hash(localAddresses);
            long node = 0L;
            for (int i = 0; i < Math.min(6, hash.length); ++i) {
                node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
            }
            assert ((0xFF00000000000000L & node) == 0L);
            return node | 0x10000000000L;
        }

        private static byte[] hash(Collection<InetAddressAndPort> data) {
            Hasher hasher = Hashing.md5().newHasher();
            for (InetAddressAndPort addr : data) {
                hasher.putBytes(addr.addressBytes);
                hasher.putInt(addr.getPort());
            }
            long pid = NativeLibrary.getProcessID();
            if (pid < 0L) {
                pid = new Random(Clock.Global.currentTimeMillis()).nextLong();
            }
            Generator.updateWithLong(hasher, pid);
            ClassLoader loader = UUIDGen.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            Generator.updateWithInt(hasher, loaderId);
            return hasher.hash().asBytes();
        }

        private static void updateWithInt(Hasher hasher, int val) {
            hasher.putByte((byte)(val >>> 24 & 0xFF));
            hasher.putByte((byte)(val >>> 16 & 0xFF));
            hasher.putByte((byte)(val >>> 8 & 0xFF));
            hasher.putByte((byte)(val >>> 0 & 0xFF));
        }

        public static void updateWithLong(Hasher hasher, long val) {
            hasher.putByte((byte)(val >>> 56 & 0xFFL));
            hasher.putByte((byte)(val >>> 48 & 0xFFL));
            hasher.putByte((byte)(val >>> 40 & 0xFFL));
            hasher.putByte((byte)(val >>> 32 & 0xFFL));
            hasher.putByte((byte)(val >>> 24 & 0xFFL));
            hasher.putByte((byte)(val >>> 16 & 0xFFL));
            hasher.putByte((byte)(val >>> 8 & 0xFFL));
            hasher.putByte((byte)(val >>> 0 & 0xFFL));
        }

        public static Collection<InetAddressAndPort> getAllLocalAddresses() {
            HashSet<InetAddressAndPort> localAddresses = new HashSet<InetAddressAndPort>();
            try {
                Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
                if (nets != null) {
                    while (nets.hasMoreElements()) {
                        Function<InetAddress, InetAddressAndPort> converter = address -> InetAddressAndPort.getByAddressOverrideDefaults(address, 0);
                        List addresses = Collections.list(nets.nextElement().getInetAddresses()).stream().map(converter).collect(Collectors.toList());
                        localAddresses.addAll(addresses);
                    }
                }
            }
            catch (SocketException e) {
                throw new AssertionError((Object)e);
            }
            if (DatabaseDescriptor.isDaemonInitialized()) {
                localAddresses.add(FBUtilities.getBroadcastAddressAndPort());
                localAddresses.add(FBUtilities.getBroadcastNativeAddressAndPort());
                localAddresses.add(FBUtilities.getLocalAddressAndPort());
            }
            return localAddresses;
        }
    }

    public static class Serializer
    extends AbstractSerializer<TimeUUID>
    implements IVersionedSerializer<TimeUUID> {
        public static final Serializer instance = new Serializer();

        @Override
        public <V> TimeUUID deserialize(V value, ValueAccessor<V> accessor) {
            return accessor.isEmpty(value) ? null : accessor.toTimeUUID(value);
        }

        @Override
        public Class<TimeUUID> getType() {
            return TimeUUID.class;
        }

        @Override
        public void serialize(TimeUUID t, DataOutputPlus out, int version) throws IOException {
            t.serialize(out);
        }

        @Override
        public TimeUUID deserialize(DataInputPlus in, int version) throws IOException {
            return TimeUUID.deserialize(in);
        }

        @Override
        public long serializedSize(TimeUUID t, int version) {
            return 16L;
        }
    }

    protected static abstract class AbstractSerializer<T extends TimeUUID>
    extends TypeSerializer<T> {
        protected AbstractSerializer() {
        }

        @Override
        public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
            if (accessor.isEmpty(value)) {
                return;
            }
            if (accessor.size(value) != 16) {
                throw new MarshalException(String.format("UUID should be 16 or 0 bytes (%d)", accessor.size(value)));
            }
            if ((accessor.getByte(value, 6) & 0xF0) != 16) {
                throw new MarshalException(String.format("Invalid version for TimeUUID type: 0x%s", Integer.toHexString(accessor.getByte(value, 0) >> 4 & 0xF)));
            }
        }

        @Override
        public String toString(T value) {
            return value == null ? "" : ((TimeUUID)value).toString();
        }

        @Override
        public ByteBuffer serialize(T value) {
            if (value == null) {
                return ByteBufferUtil.EMPTY_BYTE_BUFFER;
            }
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.putLong(((TimeUUID)value).msb());
            buffer.putLong(((TimeUUID)value).lsb());
            buffer.flip();
            return buffer;
        }
    }
}

