/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.NativeLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUtil {
    public static final boolean SKIP_SYNC;
    private static final Field mbbFDField;
    private static final Field fdClosedField;
    private static final Field fdUseCountField;
    private static final Logger logger;

    public static MappedByteBuffer force(MappedByteBuffer buf) {
        Preconditions.checkNotNull(buf);
        if (SKIP_SYNC) {
            Object fd = null;
            try {
                if (mbbFDField != null) {
                    fd = mbbFDField.get(buf);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (mbbFDField != null && fd == null) {
                throw new UnsupportedOperationException();
            }
            return buf;
        }
        return buf.force();
    }

    public static void sync(FileDescriptor fd) throws SyncFailedException {
        Preconditions.checkNotNull(fd);
        if (SKIP_SYNC) {
            boolean closed = false;
            try {
                if (fdClosedField != null) {
                    closed = fdClosedField.getBoolean(fd);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            int useCount = 1;
            try {
                if (fdUseCountField != null) {
                    useCount = ((AtomicInteger)fdUseCountField.get(fd)).get();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (closed || !fd.valid() || useCount < 0) {
                throw new SyncFailedException("Closed " + closed + " valid " + fd.valid() + " useCount " + useCount);
            }
        } else {
            fd.sync();
        }
    }

    public static void force(FileChannel fc, boolean metaData) throws IOException {
        Preconditions.checkNotNull(fc);
        if (SKIP_SYNC) {
            if (!fc.isOpen()) {
                throw new ClosedChannelException();
            }
        } else {
            fc.force(metaData);
        }
    }

    public static void sync(FileOutputStream fos) throws IOException {
        Preconditions.checkNotNull(fos);
        SyncUtil.sync(fos.getFD());
    }

    public static void trySync(int fd) {
        if (SKIP_SYNC) {
            return;
        }
        NativeLibrary.trySync(fd);
    }

    public static void trySyncDir(File dir) {
        if (SKIP_SYNC) {
            return;
        }
        int directoryFD = NativeLibrary.tryOpenDirectory(dir.path());
        try {
            SyncUtil.trySync(directoryFD);
        }
        finally {
            NativeLibrary.tryCloseFD(directoryFD);
        }
    }

    static {
        logger = LoggerFactory.getLogger(SyncUtil.class);
        Field mbbFDFieldTemp = null;
        try {
            mbbFDFieldTemp = MappedByteBuffer.class.getDeclaredField("fd");
            mbbFDFieldTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        mbbFDField = mbbFDFieldTemp;
        Field fdClosedFieldTemp = null;
        try {
            fdClosedFieldTemp = FileDescriptor.class.getDeclaredField("closed");
            fdClosedFieldTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdClosedField = fdClosedFieldTemp;
        Field fdUseCountTemp = null;
        try {
            fdUseCountTemp = FileDescriptor.class.getDeclaredField("useCount");
            fdUseCountTemp.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fdUseCountField = fdUseCountTemp;
        boolean skipSyncProperty = Boolean.getBoolean("cassandra.skip_sync");
        boolean skipSyncEnv = Boolean.valueOf(System.getenv().getOrDefault("CASSANDRA_SKIP_SYNC", "false"));
        boolean bl = SKIP_SYNC = skipSyncProperty || skipSyncEnv;
        if (SKIP_SYNC) {
            logger.info("Skip fsync enabled due to property {} and environment {}", (Object)skipSyncProperty, (Object)skipSyncEnv);
        }
    }
}

