/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import net.nmoncho.shaded.com.google.common.collect.PeekingIterator;
import net.nmoncho.shaded.com.google.common.primitives.Ints;
import net.nmoncho.shaded.com.google.common.primitives.Shorts;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RandomPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.HistogramBuilder;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerkleTree {
    private static final Logger logger = LoggerFactory.getLogger(MerkleTree.class);
    private static final int HASH_SIZE = 32;
    private static final byte[] EMPTY_HASH = new byte[32];
    private static final ThreadLocal<byte[]> byteArray = ThreadLocal.withInitial(() -> new byte[32]);
    public static final byte RECOMMENDED_DEPTH = 126;
    private final int hashdepth;
    final Range<Token> fullRange;
    private final IPartitioner partitioner;
    private long maxsize;
    private long size;
    private Node root;
    private static boolean warnedOnce;

    private static byte[] getTempArray(int minimumSize) {
        return minimumSize <= 32 ? byteArray.get() : new byte[minimumSize];
    }

    public MerkleTree(IPartitioner partitioner, Range<Token> range, int hashdepth, long maxsize) {
        this(new OnHeapLeaf(), partitioner, range, hashdepth, maxsize, 1L);
    }

    private MerkleTree(Node root, IPartitioner partitioner, Range<Token> range, int hashdepth, long maxsize, long size) {
        assert (hashdepth < 127);
        this.root = root;
        this.fullRange = Preconditions.checkNotNull(range);
        this.partitioner = Preconditions.checkNotNull(partitioner);
        this.hashdepth = hashdepth;
        this.maxsize = maxsize;
        this.size = size;
    }

    public void init() {
        int sizedepth = (int)(Math.log10(this.maxsize) / Math.log10(2.0));
        int depth = Math.min(sizedepth, this.hashdepth);
        this.root = this.initHelper((Token)this.fullRange.left, (Token)this.fullRange.right, 0, depth);
        this.size = (long)Math.pow(2.0, depth);
    }

    private OnHeapNode initHelper(Token left, Token right, int depth, int max) {
        if (depth == max) {
            return new OnHeapLeaf();
        }
        Token midpoint = this.partitioner.midpoint(left, right);
        if (midpoint.equals(left) || midpoint.equals(right)) {
            return new OnHeapLeaf();
        }
        OnHeapNode leftChild = this.initHelper(left, midpoint, depth + 1, max);
        OnHeapNode rightChild = this.initHelper(midpoint, right, depth + 1, max);
        return new OnHeapInner(midpoint, leftChild, rightChild);
    }

    public void release() {
        if (this.root instanceof OffHeapNode) {
            ((OffHeapNode)this.root).release();
        }
        this.root = null;
    }

    public IPartitioner partitioner() {
        return this.partitioner;
    }

    public long size() {
        return this.size;
    }

    public long maxsize() {
        return this.maxsize;
    }

    public void maxsize(long maxsize) {
        this.maxsize = maxsize;
    }

    public static List<TreeRange> difference(MerkleTree ltree, MerkleTree rtree) {
        if (!ltree.fullRange.equals(rtree.fullRange)) {
            throw new IllegalArgumentException("Difference only make sense on tree covering the same range (but " + ltree.fullRange + " != " + rtree.fullRange + ')');
        }
        ltree.fillInnerHashes();
        rtree.fillInnerHashes();
        ArrayList<TreeRange> diff = new ArrayList<TreeRange>();
        TreeRange active = new TreeRange((Token)ltree.fullRange.left, (Token)ltree.fullRange.right, 0);
        Node lnode = ltree.root;
        Node rnode = rtree.root;
        if (lnode.hashesDiffer(rnode)) {
            if (lnode instanceof Leaf || rnode instanceof Leaf) {
                logger.trace("Digest mismatch detected among leaf nodes {}, {}", (Object)lnode, (Object)rnode);
                diff.add(active);
            } else {
                logger.trace("Digest mismatch detected, traversing trees [{}, {}]", (Object)ltree, (Object)rtree);
                if (Difference.FULLY_INCONSISTENT == MerkleTree.differenceHelper(ltree, rtree, diff, active)) {
                    logger.trace("Range {} fully inconsistent", (Object)active);
                    diff.add(active);
                }
            }
        }
        return diff;
    }

    @VisibleForTesting
    static Difference differenceHelper(MerkleTree ltree, MerkleTree rtree, List<TreeRange> diff, TreeRange active) {
        if (active.depth == 127) {
            return Difference.CONSISTENT;
        }
        Token midpoint = ltree.partitioner().midpoint((Token)active.left, (Token)active.right);
        if (midpoint.equals(active.left) || midpoint.equals(active.right)) {
            logger.trace("({}) No sane midpoint ({}) for range {} , marking whole range as inconsistent", new Object[]{active.depth, midpoint, active});
            return Difference.FULLY_INCONSISTENT;
        }
        TreeRange left = new TreeRange((Token)active.left, midpoint, active.depth + 1);
        TreeRange right = new TreeRange(midpoint, (Token)active.right, active.depth + 1);
        logger.trace("({}) Hashing sub-ranges [{}, {}] for {} divided by midpoint {}", new Object[]{active.depth, left, right, active, midpoint});
        Node lnode = ltree.find(left);
        Node rnode = rtree.find(left);
        Difference ldiff = Difference.CONSISTENT;
        if (null != lnode && null != rnode && lnode.hashesDiffer(rnode)) {
            logger.trace("({}) Inconsistent digest on left sub-range {}: [{}, {}]", new Object[]{active.depth, left, lnode, rnode});
            ldiff = lnode instanceof Leaf ? Difference.FULLY_INCONSISTENT : MerkleTree.differenceHelper(ltree, rtree, diff, left);
        } else if (null == lnode || null == rnode) {
            logger.trace("({}) Left sub-range fully inconsistent {}", (Object)active.depth, (Object)left);
            ldiff = Difference.FULLY_INCONSISTENT;
        }
        lnode = ltree.find(right);
        rnode = rtree.find(right);
        Difference rdiff = Difference.CONSISTENT;
        if (null != lnode && null != rnode && lnode.hashesDiffer(rnode)) {
            logger.trace("({}) Inconsistent digest on right sub-range {}: [{}, {}]", new Object[]{active.depth, right, lnode, rnode});
            rdiff = rnode instanceof Leaf ? Difference.FULLY_INCONSISTENT : MerkleTree.differenceHelper(ltree, rtree, diff, right);
        } else if (null == lnode || null == rnode) {
            logger.trace("({}) Right sub-range fully inconsistent {}", (Object)active.depth, (Object)right);
            rdiff = Difference.FULLY_INCONSISTENT;
        }
        if (ldiff == Difference.FULLY_INCONSISTENT && rdiff == Difference.FULLY_INCONSISTENT) {
            logger.trace("({}) Fully inconsistent range [{}, {}]", new Object[]{active.depth, left, right});
            return Difference.FULLY_INCONSISTENT;
        }
        if (ldiff == Difference.FULLY_INCONSISTENT) {
            logger.trace("({}) Adding left sub-range to diff as fully inconsistent {}", (Object)active.depth, (Object)left);
            diff.add(left);
            return Difference.PARTIALLY_INCONSISTENT;
        }
        if (rdiff == Difference.FULLY_INCONSISTENT) {
            logger.trace("({}) Adding right sub-range to diff as fully inconsistent {}", (Object)active.depth, (Object)right);
            diff.add(right);
            return Difference.PARTIALLY_INCONSISTENT;
        }
        logger.trace("({}) Range {} partially inconstent", (Object)active.depth, (Object)active);
        return Difference.PARTIALLY_INCONSISTENT;
    }

    @VisibleForTesting
    private Node find(Range<Token> range) {
        try {
            return this.findHelper(this.root, this.fullRange, range);
        }
        catch (StopRecursion e) {
            return null;
        }
    }

    private Node findHelper(Node current, Range<Token> activeRange, Range<Token> find) throws StopRecursion {
        while (true) {
            if (current instanceof Leaf) {
                if (!find.contains((Token)((Object)activeRange))) {
                    throw new StopRecursion.BadRange();
                }
                return current;
            }
            assert (current instanceof Inner);
            Inner inner = (Inner)current;
            if (find.contains((Token)((Object)activeRange))) {
                return inner.fillInnerHashes();
            }
            Token midpoint = inner.token();
            Range<Token> leftRange = new Range<Token>((Token)activeRange.left, midpoint);
            Range<RingPosition> rightRange = new Range<RingPosition>(midpoint, activeRange.right);
            if (leftRange.contains((Token)((Object)find))) {
                activeRange = leftRange;
                current = inner.left();
                continue;
            }
            if (!rightRange.contains((RingPosition)((Object)find))) break;
            activeRange = rightRange;
            current = inner.right();
        }
        throw new StopRecursion.BadRange();
    }

    public boolean split(Token t) {
        if (this.size >= this.maxsize) {
            return false;
        }
        try {
            this.root = this.splitHelper(this.root, (Token)this.fullRange.left, (Token)this.fullRange.right, 0, t);
        }
        catch (StopRecursion.TooDeep e) {
            return false;
        }
        return true;
    }

    private OnHeapNode splitHelper(Node node, Token pleft, Token pright, int depth, Token t) throws StopRecursion.TooDeep {
        if (depth >= this.hashdepth) {
            throw new StopRecursion.TooDeep();
        }
        if (node instanceof Leaf) {
            Token midpoint = this.partitioner.midpoint(pleft, pright);
            if (midpoint.equals(pleft) || midpoint.equals(pright)) {
                throw new StopRecursion.TooDeep();
            }
            ++this.size;
            return new OnHeapInner(midpoint, new OnHeapLeaf(), new OnHeapLeaf());
        }
        assert (node instanceof OnHeapInner);
        OnHeapInner inner = (OnHeapInner)node;
        if (Range.contains(pleft, inner.token(), t)) {
            inner.left(this.splitHelper(inner.left(), pleft, inner.token(), depth + 1, t));
        } else {
            inner.right(this.splitHelper(inner.right(), inner.token(), pright, depth + 1, t));
        }
        return inner;
    }

    TreeRangeIterator rangeIterator() {
        return new TreeRangeIterator(this);
    }

    EstimatedHistogram histogramOfRowSizePerLeaf() {
        HistogramBuilder histbuild = new HistogramBuilder();
        for (TreeRange range : new TreeRangeIterator(this)) {
            histbuild.add(range.node.sizeOfRange());
        }
        return histbuild.buildWithStdevRangesAroundMean();
    }

    EstimatedHistogram histogramOfRowCountPerLeaf() {
        HistogramBuilder histbuild = new HistogramBuilder();
        for (TreeRange range : new TreeRangeIterator(this)) {
            histbuild.add(range.node.partitionsInRange());
        }
        return histbuild.buildWithStdevRangesAroundMean();
    }

    public long rowCount() {
        long count = 0L;
        for (TreeRange range : new TreeRangeIterator(this)) {
            count += range.node.partitionsInRange();
        }
        return count;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("#<MerkleTree root=");
        this.root.toString(buff, 8);
        buff.append('>');
        return buff.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof MerkleTree)) {
            return false;
        }
        MerkleTree that = (MerkleTree)other;
        return this.root.equals(that.root) && this.fullRange.equals(that.fullRange) && this.partitioner == that.partitioner && this.hashdepth == that.hashdepth && this.maxsize == that.maxsize && this.size == that.size;
    }

    public void serialize(DataOutputPlus out, int version) throws IOException {
        out.writeByte(this.hashdepth);
        out.writeLong(this.maxsize);
        out.writeLong(this.size);
        out.writeUTF(this.partitioner.getClass().getCanonicalName());
        Token.serializer.serialize((Token)this.fullRange.left, out, version);
        Token.serializer.serialize((Token)this.fullRange.right, out, version);
        this.root.serialize(out, version);
    }

    public long serializedSize(int version) {
        long size = 1 + TypeSizes.sizeof(this.maxsize) + TypeSizes.sizeof(this.size) + TypeSizes.sizeof(this.partitioner.getClass().getCanonicalName());
        size += Token.serializer.serializedSize((Token)this.fullRange.left, version);
        size += Token.serializer.serializedSize((Token)this.fullRange.right, version);
        return size += (long)this.root.serializedSize(version);
    }

    public static MerkleTree deserialize(DataInputPlus in, int version) throws IOException {
        return MerkleTree.deserialize(in, DatabaseDescriptor.useOffheapMerkleTrees(), version);
    }

    public static MerkleTree deserialize(DataInputPlus in, boolean offHeapRequested, int version) throws IOException {
        IPartitioner partitioner;
        byte hashDepth = in.readByte();
        long maxSize = in.readLong();
        int innerNodeCount = Ints.checkedCast(in.readLong());
        try {
            partitioner = FBUtilities.newPartitioner(in.readUTF());
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        Token left = Token.serializer.deserialize(in, partitioner, version);
        Token right = Token.serializer.deserialize(in, partitioner, version);
        Range<Token> fullRange = new Range<Token>(left, right);
        Node root = MerkleTree.deserializeTree(in, partitioner, innerNodeCount, offHeapRequested, version);
        return new MerkleTree(root, partitioner, fullRange, hashDepth, maxSize, innerNodeCount);
    }

    private static boolean shouldUseOffHeapTrees(IPartitioner partitioner, boolean offHeapRequested) {
        boolean offHeapSupported;
        boolean bl = offHeapSupported = partitioner instanceof Murmur3Partitioner || partitioner instanceof RandomPartitioner;
        if (offHeapRequested && !offHeapSupported && !warnedOnce) {
            logger.warn("Configuration requests off-heap merkle trees, but partitioner does not support it. Ignoring.");
            warnedOnce = true;
        }
        return offHeapRequested && offHeapSupported;
    }

    private static ByteBuffer allocate(int innerNodeCount, IPartitioner partitioner) {
        int size = MerkleTree.offHeapBufferSize(innerNodeCount, partitioner);
        logger.debug("Allocating direct buffer of size {} for an off-heap merkle tree", (Object)size);
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        if (Ref.DEBUG_ENABLED) {
            MemoryUtil.setAttachment(buffer, new Ref<Object>(null, null));
        }
        return buffer;
    }

    private static Node deserializeTree(DataInputPlus in, IPartitioner partitioner, int innerNodeCount, boolean offHeapRequested, int version) throws IOException {
        return MerkleTree.shouldUseOffHeapTrees(partitioner, offHeapRequested) ? MerkleTree.deserializeOffHeap(in, partitioner, innerNodeCount, version) : OnHeapNode.deserialize(in, partitioner, version);
    }

    MerkleTree tryMoveOffHeap() throws IOException {
        return this.root instanceof OnHeapNode && MerkleTree.shouldUseOffHeapTrees(this.partitioner, DatabaseDescriptor.useOffheapMerkleTrees()) ? this.moveOffHeap() : this;
    }

    @VisibleForTesting
    MerkleTree moveOffHeap() throws IOException {
        assert (this.root instanceof OnHeapNode);
        this.root.fillInnerHashes();
        ByteBuffer buffer = MerkleTree.allocate(Ints.checkedCast(this.size), this.partitioner);
        int pointer = ((OnHeapNode)this.root).serializeOffHeap(buffer, this.partitioner);
        OffHeapNode newRoot = MerkleTree.fromPointer(pointer, buffer, this.partitioner);
        return new MerkleTree(newRoot, this.partitioner, this.fullRange, this.hashdepth, this.maxsize, this.size);
    }

    private static OffHeapNode deserializeOffHeap(DataInputPlus in, IPartitioner partitioner, int innerNodeCount, int version) throws IOException {
        ByteBuffer buffer = MerkleTree.allocate(innerNodeCount, partitioner);
        int pointer = OffHeapNode.deserialize(in, buffer, partitioner, version);
        return MerkleTree.fromPointer(pointer, buffer, partitioner);
    }

    private static OffHeapNode fromPointer(int pointer, ByteBuffer buffer, IPartitioner partitioner) {
        return pointer >= 0 ? new OffHeapInner(buffer, pointer, partitioner) : new OffHeapLeaf(buffer, ~pointer);
    }

    private static int offHeapBufferSize(int innerNodeCount, IPartitioner partitioner) {
        return innerNodeCount * OffHeapInner.maxOffHeapSize(partitioner) + (innerNodeCount + 1) * OffHeapLeaf.maxOffHeapSize();
    }

    static byte[] xor(byte[] left, byte[] right) {
        assert (left.length == right.length);
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    private static void xorOntoLeft(byte[] left, byte[] right) {
        assert (left.length == right.length);
        for (int i = 0; i < left.length; ++i) {
            left[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
    }

    public static int estimatedMaxDepthForBytes(IPartitioner partitioner, long numBytes, int bytesPerHash) {
        byte[] hashLeft = new byte[bytesPerHash];
        byte[] hashRigth = new byte[bytesPerHash];
        OnHeapLeaf left = new OnHeapLeaf(hashLeft);
        OnHeapLeaf right = new OnHeapLeaf(hashRigth);
        OnHeapInner inner = new OnHeapInner(partitioner.getMinimumToken(), left, right);
        inner.fillInnerHashes();
        long innerTokenSize = ObjectSizes.measureDeep(partitioner.getMinimumToken());
        long realInnerTokenSize = partitioner.getMinimumToken().getHeapSize();
        long sizeOfLeaf = ObjectSizes.measureDeep(left);
        long sizeOfInner = ObjectSizes.measureDeep(inner) - (ObjectSizes.measureDeep(left) + ObjectSizes.measureDeep(right) + innerTokenSize) + realInnerTokenSize;
        long adjustedBytes = Math.max(1L, (numBytes + sizeOfInner) / (sizeOfLeaf + sizeOfInner));
        return Math.max(1, (int)Math.floor(Math.log(adjustedBytes) / Math.log(2.0)));
    }

    @VisibleForTesting
    void unsafeInvalidate(Token t) {
        this.unsafeInvalidateHelper(this.root, (Token)this.fullRange.left, t);
    }

    private void unsafeInvalidateHelper(Node node, Token pleft, Token t) {
        node.hash(EMPTY_HASH);
        if (node instanceof Leaf) {
            return;
        }
        assert (node instanceof Inner);
        Inner inner = (Inner)node;
        inner.unsafeInvalidate();
        if (Range.contains(pleft, inner.token(), t)) {
            this.unsafeInvalidateHelper(inner.left(), pleft, t);
        } else {
            this.unsafeInvalidateHelper(inner.right(), inner.token(), t);
        }
    }

    @VisibleForTesting
    byte[] hash(Range<Token> range) {
        return this.find(range).hash();
    }

    @VisibleForTesting
    <E extends Exception> boolean ifHashesRange(Range<Token> range, Consumer<E> consumer) throws E {
        try {
            boolean hasHash;
            Node node = this.findHelper(this.root, new Range<RingPosition>(this.fullRange.left, this.fullRange.right), range);
            boolean bl = hasHash = !node.hasEmptyHash();
            if (hasHash) {
                consumer.accept(node);
            }
            return hasHash;
        }
        catch (StopRecursion e) {
            return false;
        }
    }

    @VisibleForTesting
    boolean hashesRange(Range<Token> range) {
        return this.ifHashesRange(range, n -> {});
    }

    @VisibleForTesting
    public TreeRange get(Token t) {
        return this.getHelper(this.root, (Token)this.fullRange.left, (Token)this.fullRange.right, t);
    }

    private TreeRange getHelper(Node node, Token pleft, Token pright, Token t) {
        int depth = 0;
        while (!(node instanceof Leaf)) {
            assert (node instanceof Inner);
            Inner inner = (Inner)node;
            if (Range.contains(pleft, inner.token(), t)) {
                pright = inner.token();
                node = inner.left();
            } else {
                pleft = inner.token();
                node = inner.right();
            }
            ++depth;
        }
        return new TreeRange(this, pleft, pright, depth, node);
    }

    private void fillInnerHashes() {
        this.root.fillInnerHashes();
    }

    static interface Consumer<E extends Exception> {
        public void accept(Node var1) throws E;
    }

    static class OffHeapInner
    extends OffHeapNode
    implements Inner {
        static final int LEFT_CHILD_POINTER_OFFSET = 0;
        static final int RIGHT_CHILD_POINTER_OFFSET = 4;
        static final int HASH_BYTES_OFFSET = 8;
        static final int TOKEN_LENGTH_OFFSET = 40;
        static final int TOKEN_BYTES_OFFSET = 42;
        private final IPartitioner partitioner;

        OffHeapInner(ByteBuffer buffer, int offset, IPartitioner partitioner) {
            super(buffer, offset);
            this.partitioner = partitioner;
        }

        @Override
        public Token token() {
            short length = this.buffer.getShort(this.offset + 40);
            return this.partitioner.getTokenFactory().fromByteBuffer(this.buffer, this.offset + 42, length);
        }

        @Override
        public Node left() {
            return this.child(0);
        }

        @Override
        public Node right() {
            return this.child(4);
        }

        private Node child(int childOffset) {
            int pointer = this.buffer.getInt(this.offset + childOffset);
            return pointer >= 0 ? new OffHeapInner(this.buffer, pointer, this.partitioner) : new OffHeapLeaf(this.buffer, ~pointer);
        }

        @Override
        public int hashBytesOffset() {
            return this.offset + 8;
        }

        static int deserializeWithoutIdent(DataInputPlus in, ByteBuffer buffer, IPartitioner partitioner, int version) throws IOException {
            if (buffer.remaining() < OffHeapInner.maxOffHeapSize(partitioner)) {
                throw new IllegalStateException("Insufficient remaining bytes to deserialize Inner node off-heap");
            }
            int offset = buffer.position();
            int tokenSize = Token.serializer.deserializeSize(in);
            byte[] tokenBytes = MerkleTree.getTempArray(tokenSize);
            in.readFully(tokenBytes, 0, tokenSize);
            buffer.putShort(offset + 40, Shorts.checkedCast(tokenSize));
            buffer.position(offset + 42);
            buffer.put(tokenBytes, 0, tokenSize);
            int leftPointer = OffHeapNode.deserialize(in, buffer, partitioner, version);
            int rightPointer = OffHeapNode.deserialize(in, buffer, partitioner, version);
            buffer.putInt(offset + 0, leftPointer);
            buffer.putInt(offset + 4, rightPointer);
            int leftHashOffset = OffHeapInner.hashBytesOffset(leftPointer);
            int rightHashOffset = OffHeapInner.hashBytesOffset(rightPointer);
            for (int i = 0; i < 32; i += 8) {
                buffer.putLong(offset + 8 + i, buffer.getLong(leftHashOffset + i) ^ buffer.getLong(rightHashOffset + i));
            }
            return offset;
        }

        static int maxOffHeapSize(IPartitioner partitioner) {
            return 42 + partitioner.getMaxTokenSize();
        }

        static int hashBytesOffset(int pointer) {
            return pointer >= 0 ? pointer + 8 : ~pointer + 0;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            this.toString(buff, 1);
            return buff.toString();
        }
    }

    static class OnHeapInner
    extends OnHeapNode
    implements Inner {
        private final Token token;
        private OnHeapNode left;
        private OnHeapNode right;
        private boolean computed;

        OnHeapInner(Token token, OnHeapNode left, OnHeapNode right) {
            super(EMPTY_HASH);
            this.token = token;
            this.left = left;
            this.right = right;
        }

        @Override
        public Token token() {
            return this.token;
        }

        @Override
        public OnHeapNode left() {
            return this.left;
        }

        @Override
        public OnHeapNode right() {
            return this.right;
        }

        void left(OnHeapNode child) {
            this.left = child;
        }

        void right(OnHeapNode child) {
            this.right = child;
        }

        @Override
        public Node fillInnerHashes() {
            if (!this.computed) {
                this.left.fillInnerHashes();
                this.right.fillInnerHashes();
                if (!this.left.hasEmptyHash() && !this.right.hasEmptyHash()) {
                    this.hash = MerkleTree.xor(this.left.hash(), this.right.hash());
                } else if (this.left.hasEmptyHash()) {
                    this.hash = this.right.hash();
                } else if (this.right.hasEmptyHash()) {
                    this.hash = this.left.hash();
                }
                this.sizeOfRange = this.left.sizeOfRange() + this.right.sizeOfRange();
                this.partitionsInRange = this.left.partitionsInRange() + this.right.partitionsInRange();
                this.computed = true;
            }
            return this;
        }

        static OnHeapInner deserializeWithoutIdent(DataInputPlus in, IPartitioner p, int version) throws IOException {
            Token token = Token.serializer.deserialize(in, p, version);
            OnHeapNode left = OnHeapNode.deserialize(in, p, version);
            OnHeapNode right = OnHeapNode.deserialize(in, p, version);
            return new OnHeapInner(token, left, right);
        }

        @Override
        int serializeOffHeap(ByteBuffer buffer, IPartitioner partitioner) throws IOException {
            if (buffer.remaining() < OffHeapInner.maxOffHeapSize(partitioner)) {
                throw new IllegalStateException("Insufficient remaining bytes to deserialize Inner node off-heap");
            }
            int offset = buffer.position();
            int tokenSize = partitioner.getTokenFactory().byteSize(this.token);
            buffer.putShort(offset + 40, Shorts.checkedCast(tokenSize));
            buffer.position(offset + 42);
            partitioner.getTokenFactory().serialize(this.token, buffer);
            int leftPointer = this.left.serializeOffHeap(buffer, partitioner);
            int rightPointer = this.right.serializeOffHeap(buffer, partitioner);
            buffer.putInt(offset + 0, leftPointer);
            buffer.putInt(offset + 4, rightPointer);
            int leftHashOffset = OffHeapInner.hashBytesOffset(leftPointer);
            int rightHashOffset = OffHeapInner.hashBytesOffset(rightPointer);
            for (int i = 0; i < 32; i += 8) {
                buffer.putLong(offset + 8 + i, buffer.getLong(leftHashOffset + i) ^ buffer.getLong(rightHashOffset + i));
            }
            return offset;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            this.toString(buff, 1);
            return buff.toString();
        }

        @Override
        public void unsafeInvalidate() {
            this.computed = false;
        }
    }

    static interface Inner
    extends Node {
        public static final byte IDENT = 2;

        public Token token();

        public Node left();

        public Node right();

        @Override
        default public void serialize(DataOutputPlus out, int version) throws IOException {
            out.writeByte(2);
            Token.serializer.serialize(this.token(), out, version);
            this.left().serialize(out, version);
            this.right().serialize(out, version);
        }

        @Override
        default public int serializedSize(int version) {
            return 1 + (int)Token.serializer.serializedSize(this.token(), version) + this.left().serializedSize(version) + this.right().serializedSize(version);
        }

        @Override
        default public void toString(StringBuilder buff, int maxdepth) {
            buff.append("#<").append(this.getClass().getSimpleName()).append(' ').append(this.token()).append(" hash=").append(Node.toString(this.hash())).append(" children=[");
            if (maxdepth < 1) {
                buff.append('#');
            } else {
                Node left = this.left();
                if (left == null) {
                    buff.append("null");
                } else {
                    left.toString(buff, maxdepth - 1);
                }
                buff.append(' ');
                Node right = this.right();
                if (right == null) {
                    buff.append("null");
                } else {
                    right.toString(buff, maxdepth - 1);
                }
            }
            buff.append("]>");
        }

        @Override
        default public boolean equals(Node other) {
            if (!(other instanceof Inner)) {
                return false;
            }
            Inner that = (Inner)other;
            return !this.hashesDiffer(other) && this.left().equals(that.left()) && this.right().equals(that.right());
        }

        default public void unsafeInvalidate() {
        }
    }

    static class OffHeapLeaf
    extends OffHeapNode
    implements Leaf {
        static final int HASH_BYTES_OFFSET = 0;

        OffHeapLeaf(ByteBuffer buffer, int offset) {
            super(buffer, offset);
        }

        @Override
        public int hashBytesOffset() {
            return this.offset + 0;
        }

        static int deserializeWithoutIdent(DataInput in, ByteBuffer buffer) throws IOException {
            if (buffer.remaining() < OffHeapLeaf.maxOffHeapSize()) {
                throw new IllegalStateException("Insufficient remaining bytes to deserialize a Leaf node off-heap");
            }
            int position = buffer.position();
            byte hashLength = in.readByte();
            if (hashLength > 0) {
                if (hashLength != 32) {
                    throw new IllegalStateException("Hash of unexpected size when deserializing an off-heap Leaf node: " + hashLength);
                }
                byte[] hashBytes = MerkleTree.getTempArray(32);
                in.readFully(hashBytes, 0, 32);
                buffer.put(hashBytes, 0, 32);
            } else {
                buffer.put(EMPTY_HASH, 0, 32);
            }
            return ~position;
        }

        static int maxOffHeapSize() {
            return 32;
        }

        public String toString() {
            return "#<OffHeapLeaf " + Node.toString(this.hash()) + '>';
        }
    }

    static class OnHeapLeaf
    extends OnHeapNode
    implements Leaf {
        OnHeapLeaf() {
            super(EMPTY_HASH);
        }

        OnHeapLeaf(byte[] hash) {
            super(hash);
        }

        void addHash(byte[] partitionHash, long partitionSize) {
            if (this.hasEmptyHash()) {
                this.hash(partitionHash);
            } else {
                MerkleTree.xorOntoLeft(this.hash, partitionHash);
            }
            this.sizeOfRange += partitionSize;
            ++this.partitionsInRange;
        }

        static OnHeapLeaf deserializeWithoutIdent(DataInputPlus in) throws IOException {
            byte size = in.readByte();
            switch (size) {
                case 32: {
                    byte[] hash = new byte[32];
                    in.readFully(hash);
                    return new OnHeapLeaf(hash);
                }
                case 0: {
                    return new OnHeapLeaf();
                }
            }
            throw new IllegalStateException(String.format("Hash of size %d encountered, expecting %d or %d", size, 32, 0));
        }

        @Override
        int serializeOffHeap(ByteBuffer buffer, IPartitioner p) {
            if (buffer.remaining() < OffHeapLeaf.maxOffHeapSize()) {
                throw new IllegalStateException("Insufficient remaining bytes to deserialize a Leaf node off-heap");
            }
            if (this.hash.length != 32) {
                throw new IllegalArgumentException("Hash of unexpected size when serializing a Leaf off-heap: " + this.hash.length);
            }
            int position = buffer.position();
            buffer.put(this.hash);
            return ~position;
        }

        public String toString() {
            return "#<OnHeapLeaf " + Node.toString(this.hash()) + '>';
        }
    }

    static interface Leaf
    extends Node {
        public static final byte IDENT = 1;

        @Override
        default public void serialize(DataOutputPlus out, int version) throws IOException {
            byte[] hash = this.hash();
            if (!1.$assertionsDisabled && hash.length != 32) {
                throw new AssertionError();
            }
            out.writeByte(1);
            if (!this.hasEmptyHash()) {
                out.writeByte(32);
                out.write(hash);
            } else {
                out.writeByte(0);
            }
        }

        @Override
        default public int serializedSize(int version) {
            return 2 + (this.hasEmptyHash() ? 0 : 32);
        }

        @Override
        default public void toString(StringBuilder buff, int maxdepth) {
            buff.append(this.toString());
        }

        @Override
        default public boolean equals(Node other) {
            return other instanceof Leaf && !this.hashesDiffer(other);
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    static abstract class OffHeapNode
    implements Node {
        protected final ByteBuffer buffer;
        protected final int offset;

        OffHeapNode(ByteBuffer buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }

        ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public byte[] hash() {
            int position = this.buffer.position();
            this.buffer.position(this.hashBytesOffset());
            byte[] array = new byte[32];
            this.buffer.get(array);
            this.buffer.position(position);
            return array;
        }

        @Override
        public boolean hasEmptyHash() {
            return ByteBufferUtil.compare(this.buffer(), this.hashBytesOffset(), 32, EMPTY_HASH) == 0;
        }

        @Override
        public void hash(byte[] hash) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hashesDiffer(Node other) {
            return other instanceof OnHeapNode ? this.hashesDiffer((OnHeapNode)other) : this.hashesDiffer((OffHeapNode)other);
        }

        private boolean hashesDiffer(OnHeapNode other) {
            return ByteBufferUtil.compare(this.buffer(), this.hashBytesOffset(), 32, other.hash()) != 0;
        }

        private boolean hashesDiffer(OffHeapNode other) {
            int thisOffset = this.hashBytesOffset();
            int otherOffset = other.hashBytesOffset();
            for (int i = 0; i < 32; i += 8) {
                if (this.buffer().getLong(thisOffset + i) == other.buffer().getLong(otherOffset + i)) continue;
                return true;
            }
            return false;
        }

        void release() {
            Object attachment = MemoryUtil.getAttachment(this.buffer);
            if (attachment instanceof Ref) {
                ((Ref)attachment).release();
            }
            FileUtils.clean(this.buffer);
        }

        abstract int hashBytesOffset();

        static int deserialize(DataInputPlus in, ByteBuffer buffer, IPartitioner p, int version) throws IOException {
            byte ident = in.readByte();
            switch (ident) {
                case 2: {
                    return OffHeapInner.deserializeWithoutIdent(in, buffer, p, version);
                }
                case 1: {
                    return OffHeapLeaf.deserializeWithoutIdent(in, buffer);
                }
            }
            throw new IOException("Unexpected node type: " + ident);
        }
    }

    static abstract class OnHeapNode
    implements Node {
        long sizeOfRange;
        long partitionsInRange;
        protected byte[] hash;

        OnHeapNode(byte[] hash) {
            if (hash == null) {
                throw new IllegalArgumentException();
            }
            this.hash = hash;
        }

        @Override
        public byte[] hash() {
            return this.hash;
        }

        @Override
        public boolean hasEmptyHash() {
            return this.hash == EMPTY_HASH;
        }

        @Override
        public void hash(byte[] hash) {
            if (hash == null) {
                throw new IllegalArgumentException();
            }
            this.hash = hash;
        }

        @Override
        public boolean hashesDiffer(Node other) {
            return other instanceof OnHeapNode ? this.hashesDiffer((OnHeapNode)other) : this.hashesDiffer((OffHeapNode)other);
        }

        private boolean hashesDiffer(OnHeapNode other) {
            return !Arrays.equals(this.hash(), other.hash());
        }

        private boolean hashesDiffer(OffHeapNode other) {
            return ByteBufferUtil.compare(this.hash(), other.buffer(), other.hashBytesOffset(), 32) != 0;
        }

        @Override
        public long sizeOfRange() {
            return this.sizeOfRange;
        }

        @Override
        public long partitionsInRange() {
            return this.partitionsInRange;
        }

        static OnHeapNode deserialize(DataInputPlus in, IPartitioner p, int version) throws IOException {
            byte ident = in.readByte();
            switch (ident) {
                case 2: {
                    return OnHeapInner.deserializeWithoutIdent(in, p, version);
                }
                case 1: {
                    return OnHeapLeaf.deserializeWithoutIdent(in);
                }
            }
            throw new IOException("Unexpected node type: " + ident);
        }

        abstract int serializeOffHeap(ByteBuffer var1, IPartitioner var2) throws IOException;
    }

    static interface Node {
        public byte[] hash();

        public boolean hasEmptyHash();

        public void hash(byte[] var1);

        public boolean hashesDiffer(Node var1);

        default public Node fillInnerHashes() {
            return this;
        }

        default public long sizeOfRange() {
            return 0L;
        }

        default public long partitionsInRange() {
            return 0L;
        }

        public void serialize(DataOutputPlus var1, int var2) throws IOException;

        public int serializedSize(int var1);

        public void toString(StringBuilder var1, int var2);

        public static String toString(byte[] hash) {
            return hash == null ? "null" : '[' + Hex.bytesToHex(hash) + ']';
        }

        public boolean equals(Node var1);
    }

    public static class RowHash {
        public final Token token;
        public final byte[] hash;
        public final long size;

        public RowHash(Token token, byte[] hash, long size) {
            this.token = token;
            this.hash = hash;
            this.size = size;
        }

        public String toString() {
            return "#<RowHash " + this.token + ' ' + (this.hash == null ? "null" : Hex.bytesToHex(this.hash)) + " @ " + this.size + " bytes>";
        }
    }

    public static class TreeRangeIterator
    extends AbstractIterator<TreeRange>
    implements Iterable<TreeRange>,
    PeekingIterator<TreeRange> {
        private final ArrayDeque<TreeRange> tovisit = new ArrayDeque();
        private final MerkleTree tree;

        TreeRangeIterator(MerkleTree tree) {
            this.tovisit.add(new TreeRange(tree, (Token)tree.fullRange.left, (Token)tree.fullRange.right, 0, tree.root));
            this.tree = tree;
        }

        @Override
        public TreeRange computeNext() {
            while (!this.tovisit.isEmpty()) {
                TreeRange active = this.tovisit.pop();
                if (active.node instanceof Leaf) {
                    if (active.isWrapAround() && !this.tovisit.isEmpty()) {
                        this.tovisit.addLast(active);
                    }
                    return active;
                }
                Inner node = (Inner)active.node;
                TreeRange left = new TreeRange(this.tree, (Token)active.left, node.token(), active.depth + 1, node.left());
                TreeRange right = new TreeRange(this.tree, node.token(), (Token)active.right, active.depth + 1, node.right());
                if (right.isWrapAround()) {
                    this.tovisit.addLast(left);
                    this.tovisit.addFirst(right);
                    continue;
                }
                this.tovisit.addFirst(right);
                this.tovisit.addFirst(left);
            }
            return (TreeRange)this.endOfData();
        }

        @Override
        public Iterator<TreeRange> iterator() {
            return this;
        }
    }

    public static class TreeRange
    extends Range<Token> {
        private final MerkleTree tree;
        public final int depth;
        private final Node node;

        TreeRange(MerkleTree tree, Token left, Token right, int depth, Node node) {
            super(left, right);
            this.tree = tree;
            this.depth = depth;
            this.node = node;
        }

        TreeRange(Token left, Token right, int depth) {
            this(null, left, right, depth, null);
        }

        public void hash(byte[] hash) {
            assert (this.tree != null) : "Not intended for modification!";
            this.node.hash(hash);
        }

        public void addHash(RowHash entry) {
            this.addHash(entry.hash, entry.size);
        }

        void addHash(byte[] hash, long partitionSize) {
            assert (this.tree != null) : "Not intended for modification!";
            assert (this.node instanceof OnHeapLeaf);
            ((OnHeapLeaf)this.node).addHash(hash, partitionSize);
        }

        public void addAll(Iterator<RowHash> entries) {
            while (entries.hasNext()) {
                this.addHash(entries.next());
            }
        }

        @Override
        public String toString() {
            return "#<TreeRange " + super.toString() + " depth=" + this.depth + '>';
        }
    }

    static abstract class StopRecursion
    extends Exception {
        StopRecursion() {
        }

        static class BadRange
        extends StopRecursion {
            BadRange() {
            }
        }

        static class TooDeep
        extends StopRecursion {
            TooDeep() {
            }
        }
    }

    static enum Difference {
        CONSISTENT,
        FULLY_INCONSISTENT,
        PARTIALLY_INCONSISTENT;

    }
}

