/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.stream.Collectors;
import net.nmoncho.shaded.com.google.common.collect.Lists;
import net.nmoncho.shaded.com.google.common.primitives.Longs;

public class IntegerInterval {
    volatile long interval;
    private static AtomicLongFieldUpdater<IntegerInterval> intervalUpdater = AtomicLongFieldUpdater.newUpdater(IntegerInterval.class, "interval");

    private IntegerInterval(long interval) {
        this.interval = interval;
    }

    public IntegerInterval(int lower, int upper) {
        this(IntegerInterval.make(lower, upper));
    }

    public IntegerInterval(IntegerInterval src) {
        this(src.interval);
    }

    public int lower() {
        return IntegerInterval.lower(this.interval);
    }

    public int upper() {
        return IntegerInterval.upper(this.interval);
    }

    public void expandToCover(int value) {
        int upper;
        int lower;
        long prev;
        do {
            prev = this.interval;
            upper = IntegerInterval.upper(prev);
            lower = IntegerInterval.lower(prev);
            if (value > upper) {
                upper = value;
                continue;
            }
            if (value >= lower) continue;
            lower = value;
        } while (!intervalUpdater.compareAndSet(this, prev, IntegerInterval.make(lower, upper)));
    }

    public int hashCode() {
        return Long.hashCode(this.interval);
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerInterval other = (IntegerInterval)obj;
        return this.interval == other.interval;
    }

    public String toString() {
        long interval = this.interval;
        return "[" + IntegerInterval.lower(interval) + "," + IntegerInterval.upper(interval) + "]";
    }

    private static long make(int lower, int upper) {
        assert (lower <= upper);
        return ((long)lower & 0xFFFFFFFFL) << 32 | (long)upper & 0xFFFFFFFFL;
    }

    private static int lower(long interval) {
        return (int)(interval >>> 32);
    }

    private static int upper(long interval) {
        return (int)interval;
    }

    public static class Set {
        static long[] EMPTY = new long[0];
        private volatile long[] ranges = EMPTY;

        public synchronized void add(int start, int end) {
            int i;
            int lpos;
            int extend;
            assert (start <= end);
            long[] ranges = this.ranges;
            int rpos = Arrays.binarySearch(ranges, ((long)end & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL);
            if (rpos < 0) {
                rpos = -1 - rpos - 1;
            }
            if (rpos >= 0 && (extend = IntegerInterval.upper(ranges[rpos])) > end) {
                end = extend;
            }
            if ((lpos = Arrays.binarySearch(ranges, ((long)start & 0xFFFFFFFFL) << 32 | 0L)) < 0) {
                lpos = -1 - lpos;
            }
            if (--lpos >= 0 && IntegerInterval.upper(ranges[lpos]) >= start) {
                start = IntegerInterval.lower(ranges[lpos]);
                --lpos;
            }
            long[] newRanges = new long[ranges.length - (rpos - lpos) + 1];
            int dest = 0;
            for (i = 0; i <= lpos; ++i) {
                newRanges[dest++] = ranges[i];
            }
            newRanges[dest++] = IntegerInterval.make(start, end);
            for (i = rpos + 1; i < ranges.length; ++i) {
                newRanges[dest++] = ranges[i];
            }
            this.ranges = newRanges;
        }

        public boolean covers(IntegerInterval iv) {
            long l = iv.interval;
            return this.covers(IntegerInterval.lower(l), IntegerInterval.upper(l));
        }

        public boolean covers(int start, int end) {
            long[] ranges = this.ranges;
            int rpos = Arrays.binarySearch(ranges, ((long)start & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL);
            if (rpos < 0) {
                rpos = -1 - rpos - 1;
            }
            if (rpos == -1) {
                return false;
            }
            return IntegerInterval.upper(ranges[rpos]) >= end;
        }

        public int lowerBound() {
            return IntegerInterval.lower(this.ranges[0]);
        }

        public int upperBound() {
            long[] ranges = this.ranges;
            return IntegerInterval.upper(ranges[ranges.length - 1]);
        }

        public Collection<IntegerInterval> intervals() {
            return Lists.transform(Longs.asList(this.ranges), iv -> new IntegerInterval((long)iv));
        }

        public int hashCode() {
            return Arrays.hashCode(this.ranges);
        }

        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Set other = (Set)obj;
            return Arrays.equals(this.ranges, other.ranges);
        }

        public String toString() {
            return "[" + this.intervals().stream().map(IntegerInterval::toString).collect(Collectors.joining(", ")) + "]";
        }
    }
}

