/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.nmoncho.shaded.com.google.common.primitives.UnsignedLongs;
import org.apache.cassandra.utils.Architecture;
import org.apache.cassandra.utils.JVMStabilityInspector;
import sun.misc.Unsafe;

public class FastByteOperations {
    public static int compareUnsigned(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return BestHolder.BEST.compare(b1, s1, l1, b2, s2, l2);
    }

    public static int compareUnsigned(ByteBuffer b1, byte[] b2, int s2, int l2) {
        return BestHolder.BEST.compare(b1, b2, s2, l2);
    }

    public static int compareUnsigned(byte[] b1, int s1, int l1, ByteBuffer b2) {
        return -BestHolder.BEST.compare(b2, b1, s1, l1);
    }

    public static int compareUnsigned(ByteBuffer b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return BestHolder.BEST.compare(b1, s1, l1, b2, s2, l2);
    }

    public static int compareUnsigned(byte[] b1, int s1, int l1, ByteBuffer b2, int s2, int l2) {
        return -BestHolder.BEST.compare(b2, s2, l2, b1, s1, l1);
    }

    public static int compareUnsigned(ByteBuffer b1, ByteBuffer b2) {
        return BestHolder.BEST.compare(b1, b2);
    }

    public static int compareUnsigned(byte[] b1, byte[] b2) {
        return FastByteOperations.compareUnsigned(b1, 0, b1.length, b2, 0, b2.length);
    }

    public static void copy(byte[] src, int srcPosition, byte[] trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static void copy(byte[] src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static void copy(ByteBuffer src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
        BestHolder.BEST.copy(src, srcPosition, trg, trgPosition, length);
    }

    public static final class PureJavaOperations
    implements ByteOperations {
        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i = offset1;
            for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
                int a = buffer1[i] & 0xFF;
                int b = buffer2[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return length1 - length2;
        }

        @Override
        public int compare(ByteBuffer buffer1, int position1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1.hasArray()) {
                return this.compare(buffer1.array(), buffer1.arrayOffset() + position1, length1, buffer2, offset2, length2);
            }
            if (position1 != buffer1.position()) {
                buffer1 = buffer1.duplicate();
                buffer1.position(position1);
            }
            return this.compare(buffer1, ByteBuffer.wrap(buffer2, offset2, length2));
        }

        @Override
        public int compare(ByteBuffer buffer1, byte[] buffer2, int offset2, int length2) {
            if (buffer1.hasArray()) {
                return this.compare(buffer1.array(), buffer1.arrayOffset() + buffer1.position(), buffer1.remaining(), buffer2, offset2, length2);
            }
            return this.compare(buffer1, ByteBuffer.wrap(buffer2, offset2, length2));
        }

        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            int end1 = buffer1.limit();
            int end2 = buffer2.limit();
            int i = buffer1.position();
            for (int j = buffer2.position(); i < end1 && j < end2; ++i, ++j) {
                int b;
                int a = buffer1.get(i) & 0xFF;
                if (a == (b = buffer2.get(j) & 0xFF)) continue;
                return a - b;
            }
            return buffer1.remaining() - buffer2.remaining();
        }

        @Override
        public void copy(byte[] src, int srcPosition, byte[] trg, int trgPosition, int length) {
            System.arraycopy(src, srcPosition, trg, trgPosition, length);
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
            if (src.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg, trgPosition, length);
                return;
            }
            src = src.duplicate();
            src.position(srcPosition);
            src.get(trg, trgPosition, length);
        }

        @Override
        public void copy(byte[] src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
            if (trg.hasArray()) {
                System.arraycopy(src, srcPosition, trg.array(), trg.arrayOffset() + trgPosition, length);
                return;
            }
            trg.duplicate().put(src, srcPosition, length);
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
            if (src.hasArray() && trg.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg.array(), trg.arrayOffset() + trgPosition, length);
                return;
            }
            src = src.duplicate();
            src.position(srcPosition).limit(srcPosition + length);
            trg = trg.duplicate();
            trg.position(trgPosition);
            trg.put(src);
        }
    }

    public static final class UnsafeOperations
    implements ByteOperations {
        static final Unsafe theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (NoSuchFieldException e) {
                    throw new Error();
                }
                catch (IllegalAccessException e) {
                    throw new Error();
                }
            }
        });
        static final long BYTE_ARRAY_BASE_OFFSET;
        static final long DIRECT_BUFFER_ADDRESS_OFFSET;
        static final boolean BIG_ENDIAN;
        private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
        private static final long MIN_COPY_THRESHOLD = 6L;

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            return UnsafeOperations.compareTo(buffer1, BYTE_ARRAY_BASE_OFFSET + (long)offset1, length1, buffer2, BYTE_ARRAY_BASE_OFFSET + (long)offset2, length2);
        }

        @Override
        public int compare(ByteBuffer buffer1, byte[] buffer2, int offset2, int length2) {
            return this.compare(buffer1, buffer1.position(), buffer1.remaining(), buffer2, offset2, length2);
        }

        @Override
        public int compare(ByteBuffer buffer1, int position1, int length1, byte[] buffer2, int offset2, int length2) {
            long offset1;
            byte[] obj1;
            if (buffer1.hasArray()) {
                obj1 = buffer1.array();
                offset1 = BYTE_ARRAY_BASE_OFFSET + (long)buffer1.arrayOffset() + (long)position1;
            } else {
                obj1 = null;
                offset1 = theUnsafe.getLong(buffer1, DIRECT_BUFFER_ADDRESS_OFFSET) + (long)position1;
            }
            return UnsafeOperations.compareTo(obj1, offset1, length1, buffer2, BYTE_ARRAY_BASE_OFFSET + (long)offset2, length2);
        }

        @Override
        public int compare(ByteBuffer buffer1, ByteBuffer buffer2) {
            return UnsafeOperations.compareTo(buffer1, buffer2);
        }

        @Override
        public void copy(byte[] src, int srcPosition, byte[] trg, int trgPosition, int length) {
            System.arraycopy(src, srcPosition, trg, trgPosition, length);
        }

        @Override
        public void copy(ByteBuffer src, int srcPosition, byte[] trg, int trgPosition, int length) {
            if (src.hasArray()) {
                System.arraycopy(src.array(), src.arrayOffset() + srcPosition, trg, trgPosition, length);
            } else {
                UnsafeOperations.copy(null, (long)srcPosition + theUnsafe.getLong(src, DIRECT_BUFFER_ADDRESS_OFFSET), trg, trgPosition, length);
            }
        }

        @Override
        public void copy(byte[] src, int srcPosition, ByteBuffer trg, int trgPosition, int length) {
            if (trg.hasArray()) {
                System.arraycopy(src, srcPosition, trg.array(), trg.arrayOffset() + trgPosition, length);
            } else {
                UnsafeOperations.copy(null, (long)srcPosition + theUnsafe.getLong(src, Unsafe.ARRAY_BYTE_BASE_OFFSET), trg, trgPosition, length);
            }
        }

        @Override
        public void copy(ByteBuffer srcBuf, int srcPosition, ByteBuffer trgBuf, int trgPosition, int length) {
            long srcOffset;
            byte[] src;
            if (srcBuf.hasArray()) {
                src = srcBuf.array();
                srcOffset = BYTE_ARRAY_BASE_OFFSET + (long)srcBuf.arrayOffset();
            } else {
                src = null;
                srcOffset = theUnsafe.getLong(srcBuf, DIRECT_BUFFER_ADDRESS_OFFSET);
            }
            UnsafeOperations.copy((Object)src, srcOffset + (long)srcPosition, trgBuf, trgPosition, length);
        }

        public static void copy(Object src, long srcOffset, ByteBuffer trgBuf, int trgPosition, int length) {
            if (trgBuf.hasArray()) {
                UnsafeOperations.copy(src, srcOffset, trgBuf.array(), trgBuf.arrayOffset() + trgPosition, length);
            } else {
                UnsafeOperations.copy(src, srcOffset, null, (long)trgPosition + theUnsafe.getLong(trgBuf, DIRECT_BUFFER_ADDRESS_OFFSET), (long)length);
            }
        }

        public static void copy(Object src, long srcOffset, byte[] trg, int trgPosition, int length) {
            if ((long)length <= 6L) {
                for (int i = 0; i < length; ++i) {
                    trg[trgPosition + i] = theUnsafe.getByte(src, srcOffset + (long)i);
                }
            } else {
                UnsafeOperations.copy(src, srcOffset, (Object)trg, BYTE_ARRAY_BASE_OFFSET + (long)trgPosition, (long)length);
            }
        }

        public static void copy(Object src, long srcOffset, Object dst, long dstOffset, long length) {
            while (length > 0L) {
                long size = length > 0x100000L ? 0x100000L : length;
                theUnsafe.copyMemory(src, srcOffset, dst, dstOffset, size);
                length -= size;
                srcOffset += size;
                dstOffset += size;
            }
        }

        public static int compareTo(ByteBuffer buffer1, ByteBuffer buffer2) {
            long offset1;
            byte[] obj1;
            if (buffer1.hasArray()) {
                obj1 = buffer1.array();
                offset1 = BYTE_ARRAY_BASE_OFFSET + (long)buffer1.arrayOffset();
            } else {
                obj1 = null;
                offset1 = theUnsafe.getLong(buffer1, DIRECT_BUFFER_ADDRESS_OFFSET);
            }
            int length1 = buffer1.remaining();
            return UnsafeOperations.compareTo(obj1, offset1 += (long)buffer1.position(), length1, buffer2);
        }

        public static int compareTo(Object buffer1, long offset1, int length1, ByteBuffer buffer) {
            long offset2;
            byte[] obj2;
            int position = buffer.position();
            int limit = buffer.limit();
            if (buffer.hasArray()) {
                obj2 = buffer.array();
                offset2 = BYTE_ARRAY_BASE_OFFSET + (long)buffer.arrayOffset();
            } else {
                obj2 = null;
                offset2 = theUnsafe.getLong(buffer, DIRECT_BUFFER_ADDRESS_OFFSET);
            }
            int length2 = limit - position;
            return UnsafeOperations.compareTo(buffer1, offset1, length1, obj2, offset2 += (long)position, length2);
        }

        public static int compareTo(Object buffer1, long memoryOffset1, int length1, Object buffer2, long memoryOffset2, int length2) {
            int i;
            int minLength = Math.min(length1, length2);
            int wordComparisons = minLength & 0xFFFFFFF8;
            for (i = 0; i < wordComparisons; i += 8) {
                long rw;
                long lw = theUnsafe.getLong(buffer1, memoryOffset1 + (long)i);
                if (lw == (rw = theUnsafe.getLong(buffer2, memoryOffset2 + (long)i))) continue;
                if (BIG_ENDIAN) {
                    return UnsignedLongs.compare(lw, rw);
                }
                return UnsignedLongs.compare(Long.reverseBytes(lw), Long.reverseBytes(rw));
            }
            for (i = wordComparisons; i < minLength; ++i) {
                int b2;
                int b1 = theUnsafe.getByte(buffer1, memoryOffset1 + (long)i) & 0xFF;
                if (b1 == (b2 = theUnsafe.getByte(buffer2, memoryOffset2 + (long)i) & 0xFF)) continue;
                return b1 - b2;
            }
            return length1 - length2;
        }

        static {
            try {
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                DIRECT_BUFFER_ADDRESS_OFFSET = theUnsafe.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
            BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        }
    }

    private static class BestHolder {
        static final String UNSAFE_COMPARER_NAME = FastByteOperations.class.getName() + "$UnsafeOperations";
        static final ByteOperations BEST = BestHolder.getBest();

        private BestHolder() {
        }

        static ByteOperations getBest() {
            if (!Architecture.IS_UNALIGNED) {
                return new PureJavaOperations();
            }
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARER_NAME);
                ByteOperations comparer = (ByteOperations)theClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                return comparer;
            }
            catch (Throwable t) {
                JVMStabilityInspector.inspectThrowable(t);
                return new PureJavaOperations();
            }
        }
    }

    public static interface ByteOperations {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

        public int compare(ByteBuffer var1, byte[] var2, int var3, int var4);

        public int compare(ByteBuffer var1, int var2, int var3, byte[] var4, int var5, int var6);

        public int compare(ByteBuffer var1, ByteBuffer var2);

        public void copy(byte[] var1, int var2, byte[] var3, int var4, int var5);

        public void copy(ByteBuffer var1, int var2, byte[] var3, int var4, int var5);

        public void copy(byte[] var1, int var2, ByteBuffer var3, int var4, int var5);

        public void copy(ByteBuffer var1, int var2, ByteBuffer var3, int var4, int var5);
    }
}

