/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.nmoncho.shaded.com.google.common.annotations.VisibleForTesting;
import net.nmoncho.shaded.com.google.common.base.Preconditions;
import org.apache.cassandra.utils.Clock;

public class ExpiringMemoizingSupplier<T>
implements Supplier<T> {
    final Supplier<ReturnValue<T>> delegate;
    final long durationNanos;
    volatile transient T value;
    volatile transient long expirationNanos;
    private static final long serialVersionUID = 0L;

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<ReturnValue<T>> delegate, long duration, TimeUnit unit) {
        return new ExpiringMemoizingSupplier<T>(delegate, duration, unit);
    }

    ExpiringMemoizingSupplier(Supplier<ReturnValue<T>> delegate, long duration, TimeUnit unit) {
        this.delegate = Preconditions.checkNotNull(delegate);
        this.durationNanos = unit.toNanos(duration);
        Preconditions.checkArgument(duration > 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long nanos = this.expirationNanos;
        long now = Clock.Global.nanoTime();
        if (nanos == 0L || now - nanos >= 0L) {
            ExpiringMemoizingSupplier expiringMemoizingSupplier = this;
            synchronized (expiringMemoizingSupplier) {
                if (nanos == this.expirationNanos) {
                    ReturnValue<T> t = this.delegate.get();
                    if (!t.canMemoize()) {
                        return t.value();
                    }
                    this.value = t.value();
                    this.expirationNanos = now + this.durationNanos;
                    return t.value();
                }
            }
        }
        return this.value;
    }

    @VisibleForTesting
    public synchronized void expire() {
        this.expirationNanos = 0L;
    }

    public String toString() {
        return "Suppliers.memoizeWithExpiration(" + this.delegate + ", " + this.durationNanos + ", NANOS)";
    }

    public static class NotMemoized<T>
    extends ReturnValue<T> {
        public NotMemoized(T value) {
            super(value);
        }

        @Override
        public boolean canMemoize() {
            return false;
        }
    }

    public static class Memoized<T>
    extends ReturnValue<T> {
        public Memoized(T value) {
            super(value);
        }

        @Override
        public boolean canMemoize() {
            return true;
        }
    }

    public static abstract class ReturnValue<T> {
        protected final T value;

        ReturnValue(T value) {
            this.value = value;
        }

        public abstract boolean canMemoize();

        public T value() {
            return this.value;
        }
    }
}

